% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Hypothesistesting_and_armdropping.R
\name{testing_and_armdropping}
\alias{testing_and_armdropping}
\title{Title}
\usage{
testing_and_armdropping(
  K,
  armleft,
  post.prob.btcontrol,
  group,
  cutoffeff,
  cutoffful,
  treatmentindex,
  test.type
)
}
\arguments{
\item{K}{A numeric value indicating the total number of arm at the beginning of trial including both control and treatment.}

\item{armleft}{A numeric vector indicating the number of active arms before this interim analysis;}

\item{post.prob.btcontrol}{A numeric vector of posterior probability of each treatment arm better than control}

\item{group}{A numeric value. The current stage index.}

\item{cutoffeff}{A numeric vector of the cutoff value at each stage for efficacy boundary.}

\item{cutoffful}{A numeric vector of the cutoff value at each stage for futility boundary.}

\item{treatmentindex}{A numeric vector of the current active treatment arm index}

\item{test.type}{A character indicating which hypothesis testing we are use.
"Oneside": H_0: \\pi_k \\leq \\pi_0; H_0: \\pi_k \> \\pi_0
"Twoside": H_0: \\pi_k \\eq \\pi_0; H_0: \\pi_k \\neq \\pi_0}
}
\value{
A list of information including armleft: the number of active arms after this interim analysis;
treatmentindex: the index vector of active arm after this interim analysis;
stats3: the vector of conclusion on whether null hypothesis is rejected
}
\description{
Title
}
\examples{
testing_and_armdropping(
K = 4,
armleft = 4,
post.prob.btcontrol = c(0.5,0.99,0.02),
group = 3,
cutoffeff = c(1, 0.99, 0.975, 0.96, 0.95),
cutoffful = c(0, 0.01, 0.025, 0.04, 0.05),
treatmentindex = c(1,2,3),
test.type = "Oneside")

testing_and_armdropping(
K = 4,
armleft = 4,
post.prob.btcontrol = c(0.5,0.99,0.02),
group = 3,
cutoffeff = c(1, 0.99, 0.975, 0.96, 0.95),
cutoffful = c(0, 0.01, 0.025, 0.04, 0.05),
treatmentindex = c(1,2,3),
test.type = "Twoside")
}
