% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.parallel.rfc.R
\name{record.parallel}
\alias{record.parallel}
\title{Recombination Counting and Ordering}
\usage{
record.parallel(input.seq, times = 10, cores = 1, LOD = 0, max.rf = 0.5,
  tol = 1e-04, useC = TRUE)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{times}{integer. Number of replicates of the RECORD procedure.}

\item{cores}{Number of parallel processes.}

\item{LOD}{minimum LOD-Score threshold used when constructing the pairwise
recombination fraction matrix.}

\item{max.rf}{maximum recombination fraction threshold used as the LOD
value above.}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{useC}{Use the C implementation to get the matrix of recombination
fractions.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{outcross} with the raw
data.} \item{twopt}{name of the object of class \code{rf.2pts} with the
2-point analyses.}
}
\description{
Implements the marker ordering algorithm \emph{Recombination Counting and
Ordering} (\cite{Van Os et al., 2005}).
}
\details{
\emph{Recombination Counting and Ordering} (\emph{RECORD}) is an algorithm
for marker ordering in linkage groups. It is not an exhaustive search
method and, therefore, is not computationally intensive. However, it does
not guarantee that the best order is always found. The only requirement is
a matrix with recombination fractions between markers. This implementation
parallelizes over the \code{times} argument using \code{cores} parallel
processes. An optimal choice for the \code{cores} argument is usually an even
divisor of \code{times}.
}
\examples{

\dontrun{
  ##outcross example
  data(example.out)
  twopt <- rf.2pts(example.out)
  all.mark <- make.seq(twopt,"all")
  groups <- group(all.mark)
  LG1 <- make.seq(groups,1)
  LG1.rec <- record(LG1)
}

}
\references{
Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia,
A. A. F. (2009) Evaluation of algorithms used to order markers on genetics
maps. \emph{Heredity} 103: 494-502.

Van Os, H., Stam, P., Visser, R.G.F. and Van Eck, H.J. (2005) RECORD: a
novel method for ordering loci on a genetic linkage map. \emph{Theoretical
and Applied Genetics} 112: 30-40.
}
\seealso{
\code{\link[BatchMap]{make.seq}} and \code{\link[BatchMap]{map}}
}
\author{
Original implementation: Marcelo Mollinari, \email{mmollina@usp.br},
Parallel version: Bastian Schiffthaler, \email{bastian.schiffthaler@umu.se}
}
\keyword{utilities}
