% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.kmer.R
\name{optimize.kmer}
\alias{optimize.kmer}
\title{Optimize kmer Length}
\usage{
optimize.kmer(ref, max.kmer = max.kmer)
}
\arguments{
\item{ref}{object of class "DNAbin" used as a reference dataset, which contains taxon information.}

\item{max.kmer}{a numeric to indicate the length of maximal kmer.}
}
\value{
a numeric indicating the optimal kmer in the range examined.
}
\description{
Optimize kmer length by trying kmers which length is in the range from 1 to max.kmer. 
The optimal kmer will have maximumal species identification success rate.
}
\examples{

data(TibetanMoth) 
ref<-TibetanMoth[1:10,]
optimial.kmer<-optimize.kmer(ref,max.kmer=5)



}
\author{
Ai-bing ZHANG, Cai-qing YANG, Meng-di HAO, CNU, Beijing, CHINA.
}
\references{
zhangab2008(at)mail.cnu.edu.cn/zhangab2008(at)gmail.com.
}
\keyword{optimize.kmer}

