% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pgs.R
\name{create.pgs.with.continuous.phenotype.plot}
\alias{create.pgs.with.continuous.phenotype.plot}
\title{Plot PGS Scatterplots}
\usage{
create.pgs.with.continuous.phenotype.plot(
  pgs.data,
  phenotype.columns,
  hexbin.threshold = 1000,
  hexbin.colour.scheme = NULL,
  hexbin.colourkey = TRUE,
  hexbin.colourcut = seq(0, 1, length = 11),
  hexbin.mincnt = 1,
  hexbin.maxcnt = NULL,
  hexbin.xbins = 30,
  hexbin.aspect = 1,
  output.dir = NULL,
  filename.prefix = NULL,
  file.extension = "png",
  tidy.titles = FALSE,
  compute.correlation = TRUE,
  corr.legend.corner = c(0, 1),
  corr.legend.cex = 1.5,
  include.origin = FALSE,
  width = 10,
  height = 10,
  xaxes.cex = 1.5,
  yaxes.cex = 1.5,
  titles.cex = 1.5,
  point.cex = 0.75,
  border.padding = 1
)
}
\arguments{
\item{pgs.data}{data.frame PGS data as formatted by \code{apply.polygenic.score()}. Required columns are at least one of PGS, PGS.with.replaced.missing, or PGS.with.normalized.missing, and at least one continuous phenotype column.
This function is designed to work with the output of \code{apply.polygenic.score()}.}

\item{phenotype.columns}{character vector of continuous phenotype column names in pgs.data to plot}

\item{hexbin.threshold}{numeric threshold (exclusive) for cohort size at which to switch from scatterplot to hexbin plot.}

\item{hexbin.colour.scheme}{character vector of colors for hexbin plot bins. Default is \code{NULL} which uses gray/black.}

\item{hexbin.colourkey}{logical whether a legend should be drawn for a hexbinplot, defaults to \code{TRUE}.}

\item{hexbin.colourcut}{numeric vector of values covering [0, 1] that determine hexagon colour class boundaries and hexagon legend size boundaries.
Alternatively, an integer (<= hexbin.maxcnt) specifying the number of equispaced colourcut values in [0,1].}

\item{hexbin.mincnt}{integer, minimum count for a hexagon to be plotted. Default is 1.}

\item{hexbin.maxcnt}{integer, maximum count for a hexagon to be plotted. Cells with more counts are not plotted. Default is \code{NULL}.}

\item{hexbin.xbins}{integer, number of bins in the x direction for hexbin plot. Default is 30.}

\item{hexbin.aspect}{numeric, aspect ratio of hexbin plot to control plot dimensions. Default is 1.}

\item{output.dir}{character directory to save output plots}

\item{filename.prefix}{character prefix for output filenames}

\item{file.extension}{character file extension for output plots}

\item{tidy.titles}{logical whether to reformat PGS plot titles to remove periods}

\item{compute.correlation}{logical whether to compute correlation between PGS and phenotype and display in plot}

\item{corr.legend.corner}{numeric vector indicating the corner of the correlation legend e.g. \code{c(0,1)} for top left}

\item{corr.legend.cex}{numeric cex for correlation legend}

\item{include.origin}{logical whether to include the origin (zero) in plot axes}

\item{width}{numeric width of output plot in inches}

\item{height}{numeric height of output plot in inches}

\item{xaxes.cex}{numeric size for x-axis labels}

\item{yaxes.cex}{numeric size for y-axis labels}

\item{titles.cex}{numeric size for plot titles}

\item{point.cex}{numeric size for plot points}

\item{border.padding}{numeric padding for plot borders}
}
\value{
If no output directory is provided, a multipanel lattice plot object is returned, otherwise a plot is written to the indicated path and \code{NULL} is returned.
If no continuous phenotype variables are detected, a warning is issued and \code{NULL} is returned.
}
\description{
Create scatterplots for PGS data outputed by \code{apply.polygenic.score()} with continuous phenotype variables
}
\examples{
set.seed(100);

pgs.data <- data.frame(
    PGS = rnorm(100, 0, 1),
    continuous.phenotype = rnorm(100, 2, 1)
    );
 temp.dir <- tempdir();

# Basic Plot
create.pgs.with.continuous.phenotype.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'basic-plot',
    phenotype.columns = 'continuous.phenotype',
    width = 6,
    height = 6
    );

# Plot multiple PGS outputs
\donttest{
pgs.data$PGS.with.normalized.missing <- rnorm(100, 1, 1);
create.pgs.with.continuous.phenotype.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'multiple-pgs',
    phenotype.columns = 'continuous.phenotype'
    );
}

# Plot multiple phenotypes
\donttest{
pgs.data$continuous.phenotype2 <- rnorm(100, 10, 1);
create.pgs.with.continuous.phenotype.plot(
    pgs.data,
    output.dir = temp.dir,
    filename.prefix = 'multiple-phenotypes',
    phenotype.columns = c('continuous.phenotype', 'continuous.phenotype2')
    );
}
}
