% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{setMisc}
\alias{setMisc}
\title{Set miscelaneous information in a population}
\usage{
setMisc(x, node = NULL, value = NULL)
}
\arguments{
\item{x}{\code{\link{Pop-class}}}

\item{node}{character, name of the node to set within the \code{x@misc} slot}

\item{value, }{value to be saved into \code{x@misc[[*]][[node]]}; length of
\code{value} should be equal to \code{nInd(x)}; if its length is 1, then
it is repeated using \code{rep} (see examples)}
}
\value{
\code{\link{Pop-class}} with \code{x@misc[[*]][[node]]} set
basePop <- newPop(founderGenomes)

basePop <- setMisc(basePop, node = "info", value = 1)
basePop@misc
getMisc(x = basePop, node = "info")

basePop <- setMisc(basePop, node = "info2", value = c("A", "B", "C"))
basePop@misc
getMisc(x = basePop, node = "info2")

n <- nInd(basePop)
location <- vector(mode = "list", length = n)
for (ind in seq_len(n)) {
  location[[ind]] <- runif(n = 2, min = 0, max = 100)
}
location
basePop <- setMisc(basePop, node = "location", value = location)
basePop@misc
getMisc(x = basePop, node = "location")

n <- nInd(basePop)
location <- vector(mode = "list", length = n)
for (ind in c(1, 3)) {
  location[[ind]] <- runif(n = 2, min = 0, max = 100)
}
location
basePop <- setMisc(basePop, node = "location", value = location)
basePop@misc
getMisc(x = basePop, node = "location")

getMisc(x = basePop)
}
\description{
Set miscelaneous information in a population
}
\details{
A \code{NULL} in \code{value} is ignored
}
