% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play_data_adjustment.R
\name{play_data_adjustment}
\alias{play_data_adjustment}
\title{Play data adjustment}
\usage{
play_data_adjustment(df1)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the play's statistics. The parameter has to be in the format provided by the play_data_adjustment() function.}
}
\value{
The data frame obtained for the play statistics will have the following format:
        \itemize{
                \item Name of the player (Name)
                \item Games Started (GS)
                \item Points (PTS)
                \item Field Goals Made (FG)
                \item Field Goals Attempted (FGA)
                \item Field Goals Percentage (FG\%)
                \item Three Points Made (3P)
                \item Three Points Attempted (3PA)
                \item Three Points Percentage (3P\%)
                \item Two Points Made (2P)
                \item Two Points Attempted (2PA)
                \item Two Points Percentage (2P\%)
                \item Free Throw Made (FT)
                \item Free Throw Attempted (FTA)
                \item Free Throw Percentage (FT\%)
                \item And One Times (ANDONE)
                \item Assists (AST)
                \item Turnover (TOV)
        }
}
\description{
The function transform the statistics entered for later use in the rest of the functions that apply to play statistics.
}
\details{
\itemize{
                \item The data.frame must have the same columns and these represent the same as in the example.
                \item The input data.frame must have the last row that represents the team's statistics.
                \item The function allows the transformation of the play statistics to which the shooting percentages.
        }
}
\examples{

df1 <- data.frame("Name" = c("Sabonis ","Team"), "GP" = c(62,71),
"PTS" = c(387,0), "FG" = c(155,1), "FGA" = c(281,1),
"3P" = c(6,1),"3PA" = c(18,1), "FT" = c(39,1),  "FTA" = c(53,1),
"ANDONE" = c(12,1), "AST" = c(0,1), "TOV" = c(27,1))

play_data_adjustment(df1)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
