# phutil 0.0.1

This is a new submission to CRAN.

## Goals

The [{phutil}](https://tdaverse.github.io/phutil/) package is intended to be a
low-level package for hosting persistence data. It is part of the *TDAverse*
suite of packages, which are designed to provide a collection of packages for
enabling machine learning and data science tasks using persistent homology.

## Current features

The package currently exposes:

- a new data structure (the
[`persistence`](https://tdaverse.github.io/phutil/reference/persistence.html)
class) for hosting persistence data;
- a set of utility functions for coercing persistence data to and from
other data structures (e.g., `data.frame`, `tibble`, `list`, `matrix`,`PHom` and
`diagram` classes);
- a set of utility functions for computing Bottleneck and Wasserstein distances
between two persistence diagrams
([`bottleneck_distance()`](https://tdaverse.github.io/phutil/reference/distances.html)
and
[`wasserstein_distance()`](https://tdaverse.github.io/phutil/reference/distances.html))
and from a sample of persistence diagrams in a pairwise manner
([`bottleneck_pairwise_distance()`](https://tdaverse.github.io/phutil/reference/pairwise-distances.html)
and
[`wasserstein_pairwise_distance()`](https://tdaverse.github.io/phutil/reference/pairwise-distances.html)).

## Dependencies

Messages, warnings and errors are relayed to the user using the
[{rlang}](https://rlang.r-lib.org) package and the
[{cli}](https://cli.r-lib.org) package which are both licensed under the MIT
license and with no dependency trail.

Computation of distances is performed using the BSD-licensed
[Hera](https://github.com/anigmetov/hera) C++ library. The code interfacing R
and C++ is generated by the header-only [{cpp11}](https://cpp11.r-lib.org)
package which is MIT-licensed. Computation of pairwise distances is parallelized
over the number of pairs using [OpenMP](https://www.openmp.org/).
