## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  warning = FALSE,
  message = FALSE
)

## -----------------------------------------------------------------------------
library(partialling.out)
library(tinytable)
library(tinyplot)
library(palmerpenguins)
library(fwlplot)
model <- lm(bill_length_mm ~ bill_depth_mm + species, data = penguins)
summary(model)

## ----eval = FALSE-------------------------------------------------------------
#  
#  modely <- lm(bill_length_mm ~ species, data = penguins)
#  
#  modelx <- lm(bill_depth_mm ~ species, data = penguins)
#  

## -----------------------------------------------------------------------------
res <- partialling_out(model, data = penguins)

tt(head(res)) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

## -----------------------------------------------------------------------------
resmodel <- lm(res_bill_length_mm ~ res_bill_depth_mm, data = res)

print(c(model$coefficients[2], resmodel$coefficients[2]))

## -----------------------------------------------------------------------------
tt(head(partialling_out(model, penguins, both = FALSE))) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

## -----------------------------------------------------------------------------
model <- lm(
  bill_length_mm ~ bill_depth_mm + species,
  data = penguins,
  weights = penguins$body_mass_g
)
res <- partialling_out(model, data = penguins, weights = penguins$body_mass_g)


tt(head(res)) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

## -----------------------------------------------------------------------------
unweighted_model <- lm(res_bill_length_mm ~ res_bill_depth_mm, data = res)

weighted_model <- lm(
  res_bill_length_mm ~ res_bill_depth_mm,
  weights = res$weights,
  data = res
)


data.frame(
  "original model" = model$coefficients[2],
  "unweighted model" = unweighted_model$coefficients[2],
  "weighted_model" = weighted_model$coefficients[2]
) |>
  tt() |>
  format_tt(digits = 4) |>
  style_tt(align = "c")


## -----------------------------------------------------------------------------
library(fixest)

model_fixest <- feols(bill_length_mm ~ bill_depth_mm | species, data = penguins)

res_fixest <- partialling_out(model_fixest, data = penguins)
tt(head(res_fixest)) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

## -----------------------------------------------------------------------------
library(lfe)

model_lfe <- felm(bill_length_mm ~ bill_depth_mm | species, data = penguins)

res_lfe <- partialling_out(model_lfe, data = penguins)


tt(head(res_lfe)) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

## -----------------------------------------------------------------------------
#  feols(bill_depth_mm ~ bill_length_mm | species^sex, data = penguins) |>
#    partialling_out(data = penguins)

## -----------------------------------------------------------------------------
#  feols(bill_depth_mm ~ i(bill_length_mm, species) | sex, data = penguins) |>
#    partialling_out(data = penguins)

## -----------------------------------------------------------------------------
#  partialling_out(lm(bill_depth_mm ~ I(bill_length_mm^2) + species,
#                     data = penguins))
#  
#  partialling_out(lm(bill_depth_mm ~  poly(bill_length_mm, 2) + species,
#                     data = penguins[!is.na(penguins$bill_length_mm), ]))
#  

## ----fig.height = 8, fig.width = 6--------------------------------------------

tinytheme("tufte")
par(mfrow = c(2, 1))


plot_partial_residuals(res_fixest)
plot_partial_residuals(res_fixest, quantile = TRUE)

## ----fig.height = 4, fig.width = 6--------------------------------------------

fwlplot(bill_length_mm ~ bill_depth_mm | species, data = penguins)


## -----------------------------------------------------------------------------
model_fixest <- feols(
  bill_length_mm ~ bill_depth_mm | species + island,
  data = penguins,
  cluster = ~species
)


tt(head(partialling_out(model_fixest, data = penguins, cluster = ~species))) |>
  format_tt(digits = 2) |>
  style_tt(align = "c")

