/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.data;

import dr.inference.model.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.ohdsi.data.ColumnMajorSortedCoxData;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.CoxPartialLikelihood;

public class CoxData {
    private final SortedCoxData data;

    public CoxData(int[] outcome, double[] time, double[] covariate) {
        this(null, outcome, time, covariate);
    }

    public CoxData(int[] id, int[] outcome, double[] time, double[] covariate) {
        if (outcome.length != time.length || covariate.length % outcome.length != 0 || id != null && id.length != outcome.length) {
            throw new IllegalArgumentException("All dimensions must be compatible");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i = 0;
        while (i < outcome.length) {
            indices.add(i);
            ++i;
        }
        indices.sort(Comparator.comparing(o -> outcome[o]));
        indices.sort(Comparator.comparing(o -> -time[o]));
        if (id != null) {
            indices.sort(Comparator.comparing(o -> id[o]));
        }
        int[] y = this.getInt(indices, outcome);
        double[] x = this.getDouble(indices, covariate);
        int[] p = this.getInt(indices, id);
        double[] t = this.getDouble(indices, time);
        int[] w = this.getYTimesTiesCount(y, p, t);
        int[] s = this.getStrata(p, y.length);
        if (y.length != x.length) {
            x = ColumnMajorSortedCoxData.transpose(x, y.length, x.length / y.length);
        }
        this.data = new SortedCoxData(y, x, s, w, null);
    }

    public SortedCoxData getSortedData() {
        return this.data;
    }

    private boolean isFailureTie(int[] y, double[] t, int[] id, int i) {
        boolean failureTie;
        boolean bl = failureTie = y[i] == 1 && y[i + 1] == 1 && t[i] == t[i + 1];
        if (id != null) {
            failureTie = failureTie && id[i] == id[i + 1];
        }
        return failureTie;
    }

    private int[] getYTimesTiesCount(int[] y, int[] id, double[] t) {
        int[] weights = new int[y.length];
        int w = 1;
        int i = 0;
        while (i < y.length - 1) {
            if (this.isFailureTie(y, t, id, i)) {
                ++w;
                weights[i] = 0;
            } else {
                weights[i] = y[i] == 1 ? w : 0;
                w = 1;
            }
            ++i;
        }
        weights[y.length - 1] = y[y.length - 1] == 1 ? w : 0;
        return weights;
    }

    private int[] getInt(List<Integer> indices, int[] outcome) {
        if (outcome == null) {
            return null;
        }
        int[] y = new int[outcome.length];
        int i = 0;
        while (i < y.length) {
            y[i] = outcome[indices.get(i)];
            ++i;
        }
        return y;
    }

    private double[] getDouble(List<Integer> indices, double[] covariate) {
        double[] x = new double[covariate.length];
        int N = indices.size();
        int numColumns = covariate.length / N;
        int j = 0;
        while (j < numColumns) {
            int i = 0;
            while (i < N) {
                x[j * N + i] = covariate[j * N + indices.get(i)];
                ++i;
            }
            ++j;
        }
        return x;
    }

    private int[] getStrata(int[] id, int length) {
        if (id == null) {
            return new int[]{length};
        }
        ArrayList<Integer> strata = new ArrayList<Integer>();
        int last = id[0];
        int i = 1;
        while (i < id.length) {
            int current = id[i];
            if (current != last) {
                strata.add(i);
                last = current;
            }
            ++i;
        }
        strata.add(i);
        return strata.stream().mapToInt(index -> index).toArray();
    }

    public static void main(String[] args) {
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = 1;
        int[] outcome = nArray;
        double[] time = new double[]{4.0, 3.0, 3.0, 2.0, 2.0, 1.0, 1.0};
        double[] covariate = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        int[] nArray2 = new int[7];
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        int[] id = nArray2;
        double beta = 0.7357498;
        CoxData data = new CoxData(id, outcome, time, covariate);
        Parameter.Default parameter = new Parameter.Default(beta);
        CoxPartialLikelihood cox = new CoxPartialLikelihood((Parameter)parameter, data.getSortedData());
        System.err.println(cox.getLogLikelihood());
    }
}

