## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(vaxineR)
library(dplyr)

## ----data_glimpse-------------------------------------------------------------
glimpse(florida_vaccine_coverage)

# Let's look at the data for a single county
florida_vaccine_coverage %>%
  filter(County == "Leon")

## ----smart-default-example, fig.width=7, fig.height=5-------------------------
plot_outbreak_prob(disease = "Pertussis")

## ----override-default-example, fig.width=7, fig.height=5----------------------
plot_outbreak_prob(disease = "Pertussis", VE = 0.92)

## ----custom-summary-----------------------------------------------------------
summary_infection_risk(
  yr = 2024,
  disease = "Custom",
  VE = 0.88,
  r0_custom = 11
)

## ----plot-history, fig.width=7, fig.height=5----------------------------------
plot_coverage_history(county_name = c("Florida", "Broward", "Leon"))

## ----plot-risk, fig.width=7, fig.height=5-------------------------------------
plot_risk_curve(disease = "Measles", kindergarten_size = 200)

## ----save-data-example--------------------------------------------------------
plot_risk_curve(
  disease = "Chickenpox",
  save_data_to = "chickenpox_risk_data.xlsx"
)

