/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5FDmirror_H
#define H5FDmirror_H

#include "H5FDpublic.h" 

#ifdef H5_HAVE_MIRROR_VFD

#define H5FD_MIRROR (H5OPEN H5FD_MIRROR_id_g)

#define H5FD_MIRROR_VALUE H5_VFD_MIRROR

#define H5FD_MIRROR_FAPL_MAGIC 0xF8DD514C

#define H5FD_MIRROR_CURR_FAPL_T_VERSION 1

#define H5FD_MIRROR_MAX_IP_LEN 45 

typedef struct H5FD_mirror_fapl_t {
    uint32_t magic;
    uint32_t version;
    int      handshake_port;
    char     remote_ip[H5FD_MIRROR_MAX_IP_LEN + 1];
} H5FD_mirror_fapl_t;

#ifdef __cplusplus
extern "C" {
#endif

H5_DLLVAR hid_t H5FD_MIRROR_id_g;

H5_DLL herr_t H5Pget_fapl_mirror(hid_t fapl_id, H5FD_mirror_fapl_t *fa_out);

H5_DLL herr_t H5Pset_fapl_mirror(hid_t fapl_id, H5FD_mirror_fapl_t *fa);

#ifdef __cplusplus
}
#endif

#else 

#define H5FD_MIRROR (H5I_INAVLID_HID)

#endif 

#endif 
