/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.CellStyle;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;

public final class RCellStyleWrapper {
    final CellStyle cellStyle;

    public RCellStyleWrapper(CellStyle cellStyle) {
        this.cellStyle = cellStyle;
    }

    public void setBorder(String[] side, int[] border, int[] color) {
        assert (border.length == side.length && color.length == side.length);
        for (int i = 0; i < side.length; ++i) {
            BorderStyle bs = BorderStyle.valueOf((short)((short)border[i]));
            short bc = (short)color[i];
            if ("bottom".equals(side[i])) {
                this.cellStyle.setBorderBottom(bs);
                this.cellStyle.setBottomBorderColor(bc);
                continue;
            }
            if ("left".equals(side[i])) {
                this.cellStyle.setBorderLeft(bs);
                this.cellStyle.setLeftBorderColor(bc);
                continue;
            }
            if ("right".equals(side[i])) {
                this.cellStyle.setBorderRight(bs);
                this.cellStyle.setRightBorderColor(bc);
                continue;
            }
            if ("top".equals(side[i])) {
                this.cellStyle.setBorderTop(bs);
                this.cellStyle.setTopBorderColor(bc);
                continue;
            }
            throw new IllegalArgumentException("Undefined border side: '" + side[i] + "'");
        }
    }

    public void setDataFormat(String format) {
        this.cellStyle.setDataFormat(format);
    }

    public void setFillBackgroundColor(int bg) {
        this.cellStyle.setFillBackgroundColor((short)bg);
    }

    public void setFillForegroundColor(int fp) {
        this.cellStyle.setFillForegroundColor((short)fp);
    }

    public void setFillPattern(int bg) {
        this.cellStyle.setFillPattern(FillPatternType.forInt((int)bg));
    }

    public void setWrapText(boolean wrap) {
        this.cellStyle.setWrapText(wrap);
    }
}

