## ----setup, include = FALSE---------------------------------------------------
LOCAL <- identical(Sys.getenv("LOCAL"), "TRUE")

knitr::opts_chunk$set(purl = LOCAL)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
suppressPackageStartupMessages(library(SelectBoost.beta))
set.seed(321)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sim <- simulation_DATA.beta(
  n = 150, p = 6, s = 3, beta_size = c(1, -0.8, 0.6),
  corr = "ar1", rho = 0.25,
  mechanism = "jitter"
)
str(sim$X)
summary(sim$Y)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
# Normalise the predictors (centre + L2 scale)
X_norm <- sb_normalize(sim$X)

# Compute correlations
corr_mat <- sb_compute_corr(X_norm)

# Group variables whose absolute correlation exceeds 0.6
raw_groups <- sb_group_variables(corr_mat, c0 = 0.6)

# Draw eight correlated replicas for the grouped variables
X_draws <- sb_resample_groups(X_norm, raw_groups, B = 8, seed = 11)

dim(X_draws[[1]])

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
coef_path <- sb_apply_selector_manual(
  X_norm, X_draws, sim$Y, selector = betareg_step_aic
)

dim(coef_path)
coef_path[, 1:3]

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sel_freq <- sb_selection_frequency(coef_path, version = "glmnet")
sel_freq

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sb <- sb_beta(
  sim$X, sim$Y,
  B = 60,
  step.num = 0.5,
  steps.seq = c(0.9, 0.7, 0.5)
)

class(sb)
attr(sb, "selector")
rownames(sb)
round(sb, 3)

## ----cache=TRUE, eval=LOCAL---------------------------------------------------
sb_enet <- sb_beta(
  sim$X, sim$Y,
  selector = betareg_glmnet,
  B = 60,
  step.num = 0.5,
  version = "glmnet",
  choose = "bic",
  prestandardize = TRUE
)

attr(sb_enet, "selector")
colMeans(sb_enet)

