/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.SubstringReplacerRules;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="SubstringReplacer", category="Tools", toolTipText="Replace substrings in String attribute values using either literal match-and-replace or regular expression matching. The attributes to apply the match and replace rules to can be selected via a range string (e.g. 1-5,6-last) or by a comma-separated list of attribute names (/first and /last can be used to indicate the first and last attribute respectively)", iconPath="weka/gui/knowledgeflow/icons/DefaultFilter.gif")
public class SubstringReplacer
extends BaseStep {
    private static final long serialVersionUID = -8786642000811852824L;
    protected String m_matchReplaceDetails = "";
    protected transient SubstringReplacerRules m_mr;
    protected Data m_streamingData;
    protected boolean m_isReset;

    @ProgrammaticProperty
    public void setMatchReplaceDetails(String details) {
        this.m_matchReplaceDetails = details;
    }

    public String getMatchReplaceDetails() {
        return this.m_matchReplaceDetails;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_streamingData = new Data("instance");
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return Arrays.asList("instance");
        }
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        Instance inst = (Instance)data.getPrimaryPayload();
        if (this.m_isReset) {
            this.m_isReset = false;
            Instances structure = inst.dataset();
            this.m_mr = new SubstringReplacerRules(this.m_matchReplaceDetails, structure, ((StepManagerImpl)this.getStepManager()).stepStatusMessagePrefix(), this.getStepManager().getLog(), this.getStepManager().getExecutionEnvironment().getEnvironmentVariables());
        }
        if (this.getStepManager().isStreamFinished(data)) {
            this.m_streamingData.clearPayload();
            this.getStepManager().throughputFinished(this.m_streamingData);
        } else if (!this.isStopRequested()) {
            this.getStepManager().throughputUpdateStart();
            Instance outInst = this.m_mr.makeOutputInstance(inst);
            this.getStepManager().throughputUpdateEnd();
            this.m_streamingData.setPayloadElement("instance", outInst);
            this.getStepManager().outputData(this.m_streamingData);
        } else {
            this.getStepManager().interrupted();
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() > 0) {
            for (Map.Entry<String, List<StepManager>> e : this.getStepManager().getIncomingConnections().entrySet()) {
                if (e.getValue().size() <= 0) continue;
                StepManager incoming = e.getValue().get(0);
                String incomingConnType = e.getKey();
                return this.getStepManager().getIncomingStructureFromStep(incoming, incomingConnType);
            }
        }
        return null;
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SubstringReplacerStepEditorDialog";
    }
}

