/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.StepManager;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="AlterRelationName", category="Flow", toolTipText="Alter the relation name in data sets", iconPath="weka/gui/knowledgeflow/icons/DiamondPlain.gif")
public class AlterRelationName
extends BaseStep {
    private static final long serialVersionUID = 5894383194664583303L;
    protected Set<String> m_hasAltered;
    protected String m_relationNameModText = "";
    protected ModType m_modType = ModType.REPLACE;
    protected Pattern m_regexPattern;
    protected String m_regexMatch = "";
    protected boolean m_replaceAll;

    @Override
    public void stepInit() throws WekaException {
        this.m_hasAltered = new HashSet<String>();
        if (this.m_modType == ModType.REGEX && this.m_relationNameModText != null && this.m_relationNameModText.length() > 0 && this.m_regexMatch != null && this.m_regexMatch.length() > 0) {
            this.m_regexPattern = Pattern.compile(this.m_regexMatch);
        }
    }

    @OptionMetadata(displayName="Text to use", description="The text to modify the relation name with", displayOrder=0)
    public void setModificationText(String text) {
        this.m_relationNameModText = text;
    }

    public String getModificationText() {
        return this.m_relationNameModText;
    }

    @OptionMetadata(displayName="Relation name modification type", description="The type of modification to apply", displayOrder=1)
    public void setModType(ModType mod) {
        this.m_modType = mod;
    }

    public ModType getModType() {
        return this.m_modType;
    }

    @OptionMetadata(displayName="Regular expression", description="Regular expression to match when performing a REGEX modification", displayOrder=2)
    public void setRegexMatch(String match) {
        this.m_regexMatch = match;
    }

    public String getRegexMatch() {
        return this.m_regexMatch;
    }

    @OptionMetadata(displayName="Replace all regex matches", description="Replace all matching occurrences if set to true, or just the first match if set to false", displayOrder=3)
    public void setReplaceAll(boolean replaceAll) {
        this.m_replaceAll = replaceAll;
    }

    public boolean getReplaceAll() {
        return this.m_replaceAll;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        if (this.m_relationNameModText.length() > 0) {
            String toCheckKey = data.getSourceStep().getName();
            String connName = data.getConnectionName();
            if (!data.getConnectionName().equals("instance")) {
                connName = connName + "_" + data.getPayloadElement("aux_set_num", 1) + "_" + data.getPayloadElement("aux_max_set_num", 1);
            }
            if (!this.m_hasAltered.contains(toCheckKey = toCheckKey + connName)) {
                this.getStepManager().logBasic("Altering relation name for data from step '" + data.getSourceStep().getName() + "' (" + connName + ")");
                Instances insts = null;
                insts = data.getConnectionName().equals("instance") ? ((Instance)data.getPrimaryPayload()).dataset() : (Instances)data.getPrimaryPayload();
                this.applyRelationNameChange(insts);
                this.m_hasAltered.add(data.getSourceStep().getName());
            }
        }
        this.getStepManager().outputData(data);
        this.getStepManager().finished();
    }

    protected void applyRelationNameChange(Instances insts) {
        switch (this.m_modType) {
            case REPLACE: {
                insts.setRelationName(this.m_relationNameModText);
                break;
            }
            case APPEND: {
                insts.setRelationName(insts.relationName() + this.m_relationNameModText);
                break;
            }
            case PREPEND: {
                insts.setRelationName(this.m_relationNameModText + insts.relationName());
                break;
            }
            case REGEX: {
                String rel = insts.relationName();
                rel = this.m_replaceAll ? this.m_regexPattern.matcher(rel).replaceAll(this.m_relationNameModText) : this.m_regexPattern.matcher(rel).replaceFirst(this.m_relationNameModText);
                insts.setRelationName(rel);
            }
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("instance", "dataSet", "trainingSet", "testSet");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        Map<String, List<StepManager>> incomingConnected = this.getStepManager().getIncomingConnections();
        return new ArrayList<String>(incomingConnected.keySet());
    }

    protected static enum ModType {
        REPLACE,
        PREPEND,
        APPEND,
        REGEX;

    }
}

