/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import weka.core.CommandlineRunnable;
import weka.core.Environment;
import weka.core.PluginManager;
import weka.core.Settings;
import weka.core.Utils;
import weka.core.WekaException;
import weka.core.WekaPackageManager;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.knowledgeflow.KnowledgeFlowApp;
import weka.knowledgeflow.BaseExecutionEnvironment;
import weka.knowledgeflow.ExecutionFinishedCallback;
import weka.knowledgeflow.Flow;
import weka.knowledgeflow.FlowExecutor;
import weka.knowledgeflow.KFDefaults;
import weka.knowledgeflow.LogManager;
import weka.knowledgeflow.LoggingLevel;
import weka.knowledgeflow.StepManagerImpl;
import weka.knowledgeflow.steps.Note;

public class FlowRunner
implements FlowExecutor,
CommandlineRunnable {
    protected Flow m_flow;
    protected transient BaseExecutionEnvironment m_execEnv;
    protected transient Logger m_log = new SimpleLogger();
    protected transient LogManager m_logHandler;
    protected LoggingLevel m_loggingLevel = LoggingLevel.BASIC;
    protected boolean m_startSequentially;
    protected int m_numThreads = 50;
    protected int m_resourceIntensiveNumThreads = 0;
    protected List<ExecutionFinishedCallback> m_callbacks = new ArrayList<ExecutionFinishedCallback>();
    protected boolean m_wasStopped;

    public FlowRunner() {
        Settings settings = new Settings("weka", "knowledgeflow");
        settings.applyDefaults(new KFDefaults());
        this.init(settings);
    }

    public FlowRunner(Settings settings) {
        this.init(settings);
    }

    protected void init(Settings settings) {
        new BaseExecutionEnvironment();
        String execName = settings.getSetting("knowledgeflow", KnowledgeFlowApp.KnowledgeFlowGeneralDefaults.EXECUTION_ENV_KEY, "Default execution environment");
        BaseExecutionEnvironment execE = null;
        try {
            execE = (BaseExecutionEnvironment)PluginManager.getPluginInstance(BaseExecutionEnvironment.class.getCanonicalName(), execName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.m_execEnv = execE != null ? execE : new BaseExecutionEnvironment();
        this.m_execEnv.setHeadless(true);
        this.m_execEnv.setFlowExecutor(this);
        this.m_execEnv.setLog(this.m_log);
        this.m_execEnv.setSettings(settings);
        this.m_numThreads = settings.getSetting("knowledgeflow", BaseExecutionEnvironment.BaseExecutionEnvironmentDefaults.STEP_EXECUTOR_SERVICE_NUM_THREADS_KEY, 50);
        this.m_resourceIntensiveNumThreads = settings.getSetting("knowledgeflow", BaseExecutionEnvironment.BaseExecutionEnvironmentDefaults.RESOURCE_INTENSIVE_EXECUTOR_SERVICE_NUM_THREADS_KEY, 0);
    }

    @Override
    public void setSettings(Settings settings) {
        this.init(settings);
    }

    @Override
    public Settings getSettings() {
        return this.m_execEnv.getSettings();
    }

    public static void main(String[] args) {
        weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
        try {
            WekaPackageManager.loadPackages(false, true, false);
            FlowRunner fr = new FlowRunner();
            fr.run(fr, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void run(Object toRun, String[] args) throws Exception {
        if (!(toRun instanceof FlowRunner)) {
            throw new IllegalArgumentException("Object to run is not an instance of FlowRunner!");
        }
        if (args.length < 1) {
            System.err.println("Usage:\n\nFlowRunner <json flow file> [-s]\n\n\tUse -s to launch start points sequentially (default launches in parallel).");
        } else {
            Settings settings = new Settings("weka", "knowledgeflow");
            settings.loadSettings();
            settings.applyDefaults(new KFDefaults());
            FlowRunner fr = (FlowRunner)toRun;
            fr.setSettings(settings);
            String fileName = args[0];
            args[0] = "";
            fr.setLaunchStartPointsSequentially(Utils.getFlag("s", args));
            Flow flowToRun = Flow.loadFlow(new File(fileName), new SimpleLogger());
            fr.setFlow(flowToRun);
            fr.run();
            fr.waitUntilFinished();
            fr.m_logHandler.logLow("FlowRunner: Finished all flows.");
            System.exit(0);
        }
    }

    @Override
    public void addExecutionFinishedCallback(ExecutionFinishedCallback callback) {
        if (!this.m_callbacks.contains(callback)) {
            this.m_callbacks.add(callback);
        }
    }

    @Override
    public void removeExecutionFinishedCallback(ExecutionFinishedCallback callback) {
        this.m_callbacks.remove(callback);
    }

    @Override
    public Flow getFlow() {
        return this.m_flow;
    }

    @Override
    public void setFlow(Flow flow) {
        this.m_flow = flow;
    }

    @Override
    public Logger getLogger() {
        return this.m_log;
    }

    @Override
    public void setLogger(Logger logger) {
        this.m_log = logger;
        if (this.m_execEnv != null) {
            this.m_execEnv.setLog(logger);
        }
    }

    @Override
    public LoggingLevel getLoggingLevel() {
        return this.m_loggingLevel;
    }

    @Override
    public void setLoggingLevel(LoggingLevel level) {
        this.m_loggingLevel = level;
        if (this.m_execEnv != null) {
            this.m_execEnv.setLoggingLevel(level);
        }
    }

    public boolean getLaunchStartPointsSequentially() {
        return this.m_startSequentially;
    }

    public void setLaunchStartPointsSequentially(boolean s) {
        this.m_startSequentially = s;
    }

    @Override
    public BaseExecutionEnvironment getExecutionEnvironment() {
        return this.m_execEnv;
    }

    @Override
    public void setExecutionEnvironment(BaseExecutionEnvironment env) {
        this.m_execEnv = env;
    }

    public void run() throws WekaException {
        if (this.m_flow == null) {
            throw new WekaException("No flow to execute!");
        }
        if (this.m_startSequentially) {
            this.runSequentially();
        } else {
            this.runParallel();
        }
    }

    protected List<StepManagerImpl> initializeFlow() throws WekaException {
        this.m_wasStopped = false;
        if (this.m_flow == null) {
            this.m_wasStopped = true;
            for (ExecutionFinishedCallback c : this.m_callbacks) {
                c.executionFinished();
            }
            throw new WekaException("No flow to execute!");
        }
        this.m_logHandler = new LogManager(this.m_log);
        this.m_logHandler.m_statusMessagePrefix = "FlowRunner$" + this.hashCode() + "|";
        this.setLoggingLevel(this.m_execEnv.getSettings().getSetting("knowledgeflow.main", KFDefaults.LOGGING_LEVEL_KEY, LoggingLevel.BASIC, Environment.getSystemWide()));
        this.m_logHandler.setLoggingLevel(this.m_loggingLevel);
        List<StepManagerImpl> startPoints = this.m_flow.findPotentialStartPoints();
        if (startPoints.size() == 0) {
            this.m_wasStopped = true;
            this.m_logHandler.logError("FlowRunner: there don't appear to be any start points to launch!", null);
            for (ExecutionFinishedCallback c : this.m_callbacks) {
                c.executionFinished();
            }
            return null;
        }
        this.m_wasStopped = false;
        this.m_execEnv.startClientExecutionService(this.m_numThreads, this.m_resourceIntensiveNumThreads);
        if (!this.m_flow.initFlow(this)) {
            this.m_wasStopped = true;
            for (ExecutionFinishedCallback c : this.m_callbacks) {
                c.executionFinished();
            }
            throw new WekaException("Flow did not initializeFlow properly - check log.");
        }
        return startPoints;
    }

    @Override
    public void runSequentially() throws WekaException {
        List<StepManagerImpl> startPoints = this.initializeFlow();
        if (startPoints == null) {
            return;
        }
        this.runSequentially(startPoints);
    }

    @Override
    public void runParallel() throws WekaException {
        List<StepManagerImpl> startPoints = this.initializeFlow();
        if (startPoints == null) {
            return;
        }
        this.runParallel(startPoints);
    }

    protected void runSequentially(List<StepManagerImpl> startPoints) throws WekaException {
        this.m_logHandler.logDetailed("Flow runner: using execution environment - " + this.m_execEnv.getDescription());
        TreeMap<Integer, StepManagerImpl> sortedStartPoints = new TreeMap<Integer, StepManagerImpl>();
        ArrayList<StepManagerImpl> unNumbered = new ArrayList<StepManagerImpl>();
        for (StepManagerImpl s : startPoints) {
            String stepName = s.getManagedStep().getName();
            if (stepName.startsWith("!")) continue;
            if (stepName.indexOf(":") > 0) {
                try {
                    Integer num = Integer.parseInt(stepName.split(":")[0]);
                    sortedStartPoints.put(num, s);
                }
                catch (NumberFormatException ex) {
                    unNumbered.add(s);
                }
                continue;
            }
            unNumbered.add(s);
        }
        int biggest = 0;
        if (sortedStartPoints.size() > 0) {
            biggest = (Integer)sortedStartPoints.lastKey();
        }
        for (StepManagerImpl s : unNumbered) {
            sortedStartPoints.put(++biggest, s);
        }
        for (StepManagerImpl stepToStart : sortedStartPoints.values()) {
            if (stepToStart.getManagedStep() instanceof Note) continue;
            this.m_logHandler.logLow("FlowRunner: Launching start point: " + stepToStart.getManagedStep().getName());
            this.m_execEnv.launchStartPoint(stepToStart);
        }
        this.m_logHandler.logDebug("FlowRunner: Launching shutdown monitor");
        this.launchExecutorShutdownThread();
    }

    protected void runParallel(List<StepManagerImpl> startPoints) throws WekaException {
        this.m_logHandler.logDetailed("Flow runner: using execution environment - " + this.m_execEnv.getDescription());
        for (StepManagerImpl startP : startPoints) {
            if (startP.getManagedStep().getName().startsWith("!") || startP.getManagedStep() instanceof Note) continue;
            this.m_logHandler.logLow("FlowRunner: Launching start point: " + startP.getManagedStep().getName());
            this.m_execEnv.launchStartPoint(startP);
        }
        this.m_logHandler.logDebug("FlowRunner: Launching shutdown monitor");
        this.launchExecutorShutdownThread();
    }

    protected void launchExecutorShutdownThread() {
        if (this.m_execEnv != null) {
            Thread shutdownThread = new Thread(){

                @Override
                public void run() {
                    FlowRunner.this.waitUntilFinished();
                    FlowRunner.this.m_logHandler.logDebug("FlowRunner: Shutting down executor service");
                    FlowRunner.this.m_execEnv.stopClientExecutionService();
                    for (ExecutionFinishedCallback c : FlowRunner.this.m_callbacks) {
                        c.executionFinished();
                    }
                }
            };
            shutdownThread.start();
        }
    }

    @Override
    public void waitUntilFinished() {
        try {
            boolean busy;
            Thread.sleep(800L);
            while (busy = this.flowBusy()) {
                Thread.sleep(3000L);
            }
        }
        catch (Exception ex) {
            this.m_logHandler.logDetailed("FlowRunner: Attempting to stop all steps...");
        }
    }

    public boolean flowBusy() {
        boolean busy = false;
        Iterator<StepManagerImpl> iter = this.m_flow.iterator();
        while (iter.hasNext()) {
            StepManagerImpl s = iter.next();
            if (!s.isStepBusy()) continue;
            this.m_logHandler.logDebug(s.getName() + " is still busy.");
            busy = true;
        }
        return busy;
    }

    @Override
    public synchronized void stopProcessing() {
        Iterator<StepManagerImpl> iter = this.m_flow.iterator();
        while (iter.hasNext()) {
            iter.next().stopStep();
        }
        System.err.println("Asked all steps to stop...");
        this.m_wasStopped = true;
    }

    @Override
    public boolean wasStopped() {
        return this.m_wasStopped;
    }

    @Override
    public void preExecution() throws Exception {
    }

    @Override
    public void postExecution() throws Exception {
    }

    public static class SimpleLogger
    implements Logger {
        SimpleDateFormat m_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        @Override
        public void logMessage(String lm) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + lm);
        }

        @Override
        public void statusMessage(String lm) {
        }
    }
}

