/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.converters.FileSourcedConverter;
import weka.gui.EnvironmentField;
import weka.gui.FileEnvironmentField;
import weka.gui.PropertySheetPanel;
import weka.gui.knowledgeflow.GOEStepEditorDialog;
import weka.knowledgeflow.steps.Saver;
import weka.knowledgeflow.steps.Step;

public class SaverStepEditorDialog
extends GOEStepEditorDialog {
    private static final long serialVersionUID = -8353826767500440827L;
    protected EnvironmentField m_prefixOrFile;
    protected FileEnvironmentField m_directory;
    protected JLabel m_dirLab = new JLabel("Directory ", 4);
    protected JLabel m_prefLab = new JLabel("Prefix ", 4);

    @Override
    public void setStepToEdit(Step step) {
        this.copyOriginal(step);
        Saver wrappedStep = (Saver)step;
        if (wrappedStep.getSaver() instanceof FileSourcedConverter) {
            this.setupFileSaver(wrappedStep);
        } else {
            super.setStepToEdit(step);
        }
    }

    protected void setupFileSaver(final Saver wrappedStep) {
        this.addPrimaryEditorPanel("North");
        this.m_prefixOrFile = new EnvironmentField();
        this.m_prefixOrFile.setEnvironment(this.m_env);
        this.m_directory = new FileEnvironmentField("", 1, true);
        this.m_directory.setEnvironment(this.m_env);
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        this.m_secondaryEditor = new PropertySheetPanel(false);
        this.m_secondaryEditor.setEnvironment(this.m_env);
        this.m_secondaryEditor.setTarget(this.m_stepToEdit);
        p.add((Component)this.m_secondaryEditor, "North");
        JPanel tp = new JPanel();
        tp.setLayout(new BorderLayout());
        JPanel dp = new JPanel();
        dp.setLayout(new GridLayout(0, 1));
        dp.add(this.m_dirLab);
        dp.add(this.m_prefLab);
        JPanel dp2 = new JPanel();
        dp2.setLayout(new GridLayout(0, 1));
        dp2.add(this.m_directory);
        dp2.add(this.m_prefixOrFile);
        tp.add((Component)dp, "West");
        tp.add((Component)dp2, "Center");
        p.add((Component)tp, "Center");
        this.m_primaryEditorHolder.add((Component)p, "Center");
        this.add((Component)this.m_editorHolder, "Center");
        if (!wrappedStep.getRelationNameForFilename()) {
            this.m_prefLab.setText("Filename");
        }
        try {
            String dir = wrappedStep.getSaver().retrieveDir();
            String prefixOrFile = wrappedStep.getSaver().filePrefix();
            this.m_directory.setText(dir);
            this.m_prefixOrFile.setText(prefixOrFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_secondaryEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (wrappedStep.getRelationNameForFilename()) {
                    if (SaverStepEditorDialog.this.m_prefLab.getText().startsWith("File")) {
                        SaverStepEditorDialog.this.m_prefLab.setText("Prefix ");
                    }
                } else if (SaverStepEditorDialog.this.m_prefLab.getText().startsWith("Prefix")) {
                    SaverStepEditorDialog.this.m_prefLab.setText("Filename ");
                }
            }
        });
    }

    protected void setupOther() {
        this.addPrimaryEditorPanel("North");
        this.addSecondaryEditorPanel("Center");
        this.add((Component)this.m_editorHolder, "Center");
    }

    @Override
    protected void okPressed() {
        if (((Saver)this.m_stepToEdit).getSaver() instanceof FileSourcedConverter) {
            try {
                ((Saver)this.m_stepToEdit).getSaver().setDir(this.m_directory.getText());
                ((Saver)this.m_stepToEdit).getSaver().setFilePrefix(this.m_prefixOrFile.getText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.okPressed();
    }
}

