/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import weka.core.Instances;

public class AttributeSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 627131485290359194L;
    protected JButton m_IncludeAll = new JButton("All");
    protected JButton m_RemoveAll = new JButton("None");
    protected JButton m_Invert = new JButton("Invert");
    protected JButton m_Pattern = new JButton("Pattern");
    protected JTable m_Table = new JTable();
    protected AttributeTableModel m_Model;
    protected String m_PatternRegEx = "";

    public AttributeSelectionPanel() {
        this(true, true, true, true);
    }

    public AttributeSelectionPanel(boolean include, boolean remove, boolean invert, boolean pattern) {
        this.m_IncludeAll.setToolTipText("Selects all attributes");
        this.m_IncludeAll.setEnabled(false);
        this.m_IncludeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.includeAll();
            }
        });
        this.m_RemoveAll.setToolTipText("Unselects all attributes");
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.removeAll();
            }
        });
        this.m_Invert.setToolTipText("Inverts the current attribute selection");
        this.m_Invert.setEnabled(false);
        this.m_Invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributeSelectionPanel.this.m_Model.invert();
            }
        });
        this.m_Pattern.setToolTipText("Selects all attributes that match a reg. expression");
        this.m_Pattern.setEnabled(false);
        this.m_Pattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String pattern = JOptionPane.showInputDialog(AttributeSelectionPanel.this.m_Pattern.getParent(), "Enter a Perl regular expression", AttributeSelectionPanel.this.m_PatternRegEx);
                if (pattern != null) {
                    try {
                        Pattern.compile(pattern);
                        AttributeSelectionPanel.this.m_PatternRegEx = pattern;
                        AttributeSelectionPanel.this.m_Model.pattern(pattern);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(AttributeSelectionPanel.this.m_Pattern.getParent(), "'" + pattern + "' is not a valid Perl regular expression!\nError: " + ex, "Error in Pattern...", 0);
                    }
                }
            }
        });
        this.m_Table.setSelectionMode(0);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.m_Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    AttributeSelectionPanel.this.popupCopyRangeMenu(e.getX(), e.getY());
                }
            }
        });
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        p1.setLayout(new GridLayout(1, 4, 5, 5));
        if (include) {
            p1.add(this.m_IncludeAll);
        }
        if (remove) {
            p1.add(this.m_RemoveAll);
        }
        if (invert) {
            p1.add(this.m_Invert);
        }
        if (pattern) {
            p1.add(this.m_Pattern);
        }
        this.setLayout(new BorderLayout());
        if (include || remove || invert || pattern) {
            this.add((Component)p1, "North");
        }
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.m_Table.getPreferredScrollableViewportSize();
    }

    public void setPreferredScrollableViewportSize(Dimension d) {
        this.m_Table.setPreferredScrollableViewportSize(d);
    }

    protected void popupCopyRangeMenu(int x, int y) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyRangeItem = new JMenuItem("Copy checked items to range in clipboard");
        popupMenu.add(copyRangeItem);
        if (this.getSelectedAttributes().length == 0) {
            copyRangeItem.setEnabled(false);
        }
        copyRangeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = AttributeSelectionPanel.this.getSelectedAttributes();
                StringBuilder b = new StringBuilder();
                int prev = -1;
                int lastInString = -1;
                for (int v : selected) {
                    if (v == 0) {
                        b.append("first-");
                        prev = v;
                        lastInString = v;
                        continue;
                    }
                    if (prev < 0) {
                        prev = v;
                        lastInString = v;
                        b.append(v + 1).append("-");
                        continue;
                    }
                    if (v - prev == 1) {
                        prev = v;
                        continue;
                    }
                    if (b.charAt(b.length() - 1) == '-') {
                        if (prev == lastInString) {
                            b.setCharAt(b.length() - 1, ',');
                        } else {
                            b.append(prev + 1).append(",");
                        }
                    }
                    if (v == AttributeSelectionPanel.this.m_Model.getRowCount() - 1) {
                        b.append("last");
                    } else {
                        b.append(v + 1).append("-");
                    }
                    prev = v;
                    lastInString = v;
                }
                if (b.charAt(b.length() - 1) == '-') {
                    if (selected.length > 1 && lastInString != selected[selected.length - 1]) {
                        if (selected[selected.length - 1] == AttributeSelectionPanel.this.m_Model.getRowCount() - 1) {
                            b.append("last");
                        } else {
                            b.append(selected[selected.length - 1] + 1);
                        }
                    } else {
                        b.setLength(b.length() - 1);
                    }
                }
                StringSelection selection = new StringSelection(b.toString());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            }
        });
        popupMenu.show(this.m_Table, x, y);
    }

    public void setInstances(Instances newInstances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(newInstances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setMaxWidth(60);
            tcm.getColumn(1).setMaxWidth(tcm.getColumn(1).getMinWidth());
            tcm.getColumn(2).setMinWidth(100);
        } else {
            this.m_Model.setInstances(newInstances);
            this.m_Table.clearSelection();
        }
        this.m_IncludeAll.setEnabled(true);
        this.m_RemoveAll.setEnabled(true);
        this.m_Invert.setEnabled(true);
        this.m_Pattern.setEnabled(true);
        this.m_Table.sizeColumnsToFit(2);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model == null ? null : this.m_Model.getSelectedAttributes();
    }

    public void setSelectedAttributes(boolean[] selected) throws Exception {
        if (this.m_Model != null) {
            this.m_Model.setSelectedAttributes(selected);
        }
    }

    public TableModel getTableModel() {
        return this.m_Model;
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("supply the name of an arff file");
            }
            Instances i = new Instances(new BufferedReader(new FileReader(args[0])));
            AttributeSelectionPanel asp = new AttributeSelectionPanel();
            final JFrame jf = new JFrame("Attribute Selection Panel");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)asp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            asp.setInstances(i);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4152987434024338064L;
        protected Instances m_Instances;
        protected boolean[] m_Selected;

        public AttributeTableModel(Instances instances) {
            this.setInstances(instances);
        }

        public void setInstances(Instances instances) {
            this.m_Instances = instances;
            this.m_Selected = new boolean[this.m_Instances.numAttributes()];
        }

        @Override
        public int getRowCount() {
            return this.m_Selected.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return new Boolean(this.m_Selected[row]);
                }
                case 2: {
                    return this.m_Instances.attribute(row).name();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String("");
                }
                case 2: {
                    return new String("Name");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.m_Selected[row] = (Boolean)value;
                this.fireTableRowsUpdated(0, this.m_Selected.length);
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            int[] r1 = new int[this.getRowCount()];
            int selCount = 0;
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (!this.m_Selected[i]) continue;
                r1[selCount++] = i;
            }
            int[] result = new int[selCount];
            System.arraycopy(r1, 0, result, 0, selCount);
            return result;
        }

        public void includeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = true;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void removeAll() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = false;
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void invert() {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = !this.m_Selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void pattern(String pattern) {
            for (int i = 0; i < this.m_Selected.length; ++i) {
                this.m_Selected[i] = Pattern.matches(pattern, this.m_Instances.attribute(i).name());
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }

        public void setSelectedAttributes(boolean[] selected) throws Exception {
            if (selected.length != this.m_Selected.length) {
                throw new Exception("Supplied array does not have the same number of elements as there are attributes!");
            }
            for (int i = 0; i < selected.length; ++i) {
                this.m_Selected[i] = selected[i];
            }
            this.fireTableRowsUpdated(0, this.m_Selected.length);
        }
    }
}

