/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixCSV
extends ResultMatrix {
    private static final long serialVersionUID = -171838863135042743L;

    public ResultMatrixCSV() {
        this(1, 1);
    }

    public ResultMatrixCSV(int cols, int rows) {
        super(cols, rows);
    }

    public ResultMatrixCSV(ResultMatrix matrix) {
        super(matrix);
    }

    @Override
    public String globalInfo() {
        return "Generates the matrix in CSV ('comma-separated values') format.";
    }

    @Override
    public String getDisplayName() {
        return "CSV";
    }

    @Override
    public void clear() {
        super.clear();
        this.LEFT_PARENTHESES = "[";
        this.RIGHT_PARENTHESES = "]";
    }

    @Override
    public int getDefaultRowNameWidth() {
        return 25;
    }

    @Override
    public boolean getDefaultPrintColNames() {
        return false;
    }

    @Override
    public boolean getDefaultEnumerateColNames() {
        return true;
    }

    @Override
    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    @Override
    public String toStringMatrix() {
        StringBuffer result = new StringBuffer();
        String[][] cells = this.toArray();
        for (int i = 0; i < cells.length; ++i) {
            for (int n = 0; n < cells[i].length; ++n) {
                if (n > 0) {
                    result.append(",");
                }
                result.append(Utils.quote(cells[i][n]));
            }
            result.append("\n");
        }
        return result.toString();
    }

    @Override
    public String toStringKey() {
        String result = "Key,\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            result = result + this.LEFT_PARENTHESES + (i + 1) + this.RIGHT_PARENTHESES + "," + Utils.quote(this.removeFilterName(this.m_ColNames[i])) + "\n";
        }
        return result;
    }

    @Override
    public String toStringSummary() {
        int i;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String result = "";
        String titles = "";
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            if (!titles.equals("")) {
                titles = titles + ",";
            }
            titles = titles + this.getSummaryTitle(i);
        }
        result = result + titles + ",'(No. of datasets where [col] >> [row])'\n";
        for (i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            String line = "";
            for (int j = 0; j < this.getColCount(); ++j) {
                if (this.getColHidden(j)) continue;
                if (!line.equals("")) {
                    line = line + ",";
                }
                line = j == i ? line + "-" : line + this.m_NonSigWins[i][j] + " (" + this.m_Wins[i][j] + ")";
            }
            result = result + line + "," + this.getSummaryTitle(i) + " = " + this.removeFilterName(this.m_ColNames[i]) + '\n';
        }
        return result;
    }

    @Override
    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        String result = ">-<,>,<,Resultset\n";
        int[] ranking = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int curr = ranking[i];
            if (this.getColHidden(curr)) continue;
            result = result + this.m_RankingDiff[curr] + "," + this.m_RankingWins[curr] + "," + this.m_RankingLosses[curr] + "," + this.removeFilterName(this.m_ColNames[curr]) + "\n";
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        ResultMatrixCSV matrix = new ResultMatrixCSV(3, 3);
        matrix.addHeader("header1", "value1");
        matrix.addHeader("header2", "value2");
        matrix.addHeader("header2", "value3");
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            for (int n = 0; n < matrix.getColCount(); ++n) {
                matrix.setMean(n, i, (i + 1) * n);
                matrix.setStdDev(n, i, (double)(i + 1) * (double)n / 100.0);
                if (i != n) continue;
                if (i % 2 == 1) {
                    matrix.setSignificance(n, i, 1);
                    continue;
                }
                matrix.setSignificance(n, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)matrix).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)matrix).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)matrix).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        matrix.setShowStdDev(true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        matrix.setPrintColNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        matrix.setColHidden(1, true);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        matrix.setRowHidden(2, true);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        matrix.setMeanPrec(3);
        matrix.setPrintRowNames(false);
        System.out.println(((ResultMatrix)matrix).toStringMatrix());
    }
}

