/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.QRP;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import no.uib.cipr.matrix.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.evaluation.RegressionAnalysis;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LinearRegression
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler {
    public static final int SELECTION_M5 = 0;
    public static final int SELECTION_NONE = 1;
    public static final int SELECTION_GREEDY = 2;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(1, "No attribute selection"), new Tag(0, "M5 method"), new Tag(2, "Greedy method")};
    static final long serialVersionUID = -3364580862046573747L;
    protected double[] m_Coefficients;
    protected boolean[] m_SelectedAttributes;
    protected Instances m_TransformedData;
    protected ReplaceMissingValues m_MissingFilter;
    protected NominalToBinary m_TransformFilter;
    protected double m_ClassStdDev;
    protected double m_ClassMean;
    protected int m_ClassIndex;
    protected double[] m_Means;
    protected double[] m_StdDevs;
    protected boolean m_outputAdditionalStats;
    protected int m_AttributeSelection;
    protected boolean m_EliminateColinearAttributes = true;
    protected boolean m_checksTurnedOff = false;
    protected boolean m_useQRDecomposition = false;
    protected double m_Ridge = 1.0E-8;
    protected boolean m_Minimal = false;
    protected boolean m_ModelBuilt = false;
    protected boolean m_isZeroR;
    private int m_df;
    private double m_RSquared;
    private double m_RSquaredAdj;
    private double m_FStat;
    private double[] m_StdErrorOfCoef;
    private double[] m_TStats;

    public LinearRegression() {
        this.m_numDecimalPlaces = 4;
    }

    public static void main(String[] argv) {
        LinearRegression.runClassifier(new LinearRegression(), argv);
    }

    public String globalInfo() {
        return "Class for using linear regression for prediction. Uses the Akaike criterion for model selection, and is able to deal with weighted instances.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.m_ModelBuilt = false;
        this.m_isZeroR = false;
        if (data.numInstances() == 1) {
            this.m_Coefficients = new double[1];
            this.m_Coefficients[0] = data.instance(0).classValue();
            this.m_SelectedAttributes = new boolean[data.numAttributes()];
            this.m_isZeroR = true;
            return;
        }
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(data);
            if (this.m_outputAdditionalStats) {
                boolean ok = true;
                for (i = 0; i < data.numInstances(); ++i) {
                    if (data.instance(i).weight() == 1.0) continue;
                    ok = false;
                    break;
                }
                if (!ok) {
                    throw new Exception("Can only compute additional statistics on unweighted data");
                }
            }
            data = new Instances(data);
            data.deleteWithMissingClass();
            this.m_TransformFilter = new NominalToBinary();
            this.m_TransformFilter.setInputFormat(data);
            data = Filter.useFilter(data, this.m_TransformFilter);
            this.m_MissingFilter = new ReplaceMissingValues();
            this.m_MissingFilter.setInputFormat(data);
            data = Filter.useFilter(data, this.m_MissingFilter);
            data.deleteWithMissingClass();
        } else {
            this.m_TransformFilter = null;
            this.m_MissingFilter = null;
        }
        this.m_ClassIndex = data.classIndex();
        this.m_TransformedData = data;
        this.m_Coefficients = null;
        this.m_SelectedAttributes = new boolean[data.numAttributes()];
        this.m_Means = new double[data.numAttributes()];
        this.m_StdDevs = new double[data.numAttributes()];
        for (int j = 0; j < data.numAttributes(); ++j) {
            if (j == this.m_ClassIndex) continue;
            this.m_SelectedAttributes[j] = true;
            this.m_Means[j] = data.meanOrMode(j);
            this.m_StdDevs[j] = Math.sqrt(data.variance(j));
            if (this.m_StdDevs[j] != 0.0) continue;
            this.m_SelectedAttributes[j] = false;
        }
        this.m_ClassStdDev = Math.sqrt(data.variance(this.m_TransformedData.classIndex()));
        this.m_ClassMean = data.meanOrMode(this.m_TransformedData.classIndex());
        this.findBestModel();
        if (this.m_outputAdditionalStats) {
            int k = 1;
            for (i = 0; i < data.numAttributes(); ++i) {
                if (i == data.classIndex() || !this.m_SelectedAttributes[i]) continue;
                ++k;
            }
            this.m_df = this.m_TransformedData.numInstances() - k;
            double se = this.calculateSE(this.m_SelectedAttributes, this.m_Coefficients);
            this.m_RSquared = RegressionAnalysis.calculateRSquared(this.m_TransformedData, se);
            this.m_RSquaredAdj = RegressionAnalysis.calculateAdjRSquared(this.m_RSquared, this.m_TransformedData.numInstances(), k);
            this.m_FStat = RegressionAnalysis.calculateFStat(this.m_RSquared, this.m_TransformedData.numInstances(), k);
            this.m_StdErrorOfCoef = RegressionAnalysis.calculateStdErrorOfCoef(this.m_TransformedData, this.m_SelectedAttributes, se, this.m_TransformedData.numInstances(), k);
            this.m_TStats = RegressionAnalysis.calculateTStats(this.m_Coefficients, this.m_StdErrorOfCoef, k);
        }
        if (this.m_Minimal) {
            this.m_TransformedData = null;
            this.m_Means = null;
            this.m_StdDevs = null;
        } else {
            this.m_TransformedData = new Instances(data, 0);
        }
        this.m_ModelBuilt = true;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Instance transformedInstance = instance;
        if (!this.m_checksTurnedOff && !this.m_isZeroR) {
            this.m_TransformFilter.input(transformedInstance);
            this.m_TransformFilter.batchFinished();
            transformedInstance = this.m_TransformFilter.output();
            this.m_MissingFilter.input(transformedInstance);
            this.m_MissingFilter.batchFinished();
            transformedInstance = this.m_MissingFilter.output();
        }
        return this.regressionPrediction(transformedInstance, this.m_SelectedAttributes, this.m_Coefficients);
    }

    public String toString() {
        if (!this.m_ModelBuilt) {
            return "Linear Regression: No model built yet.";
        }
        if (this.m_Minimal) {
            return "Linear Regression: Model built.";
        }
        try {
            StringBuilder text = new StringBuilder();
            int column = 0;
            boolean first = true;
            text.append("\nLinear Regression Model\n\n");
            text.append(this.m_TransformedData.classAttribute().name() + " =\n\n");
            for (int i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
                if (i == this.m_ClassIndex || !this.m_SelectedAttributes[i]) continue;
                if (!first) {
                    text.append(" +\n");
                } else {
                    first = false;
                }
                text.append(Utils.doubleToString(this.m_Coefficients[column], 12, this.m_numDecimalPlaces) + " * ");
                text.append(this.m_TransformedData.attribute(i).name());
                ++column;
            }
            text.append(" +\n" + Utils.doubleToString(this.m_Coefficients[column], 12, this.m_numDecimalPlaces));
            if (this.m_outputAdditionalStats) {
                int i;
                int maxAttLength = 0;
                for (i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
                    if (i == this.m_ClassIndex || !this.m_SelectedAttributes[i] || this.m_TransformedData.attribute(i).name().length() <= maxAttLength) continue;
                    maxAttLength = this.m_TransformedData.attribute(i).name().length();
                }
                if ((maxAttLength += 3) < "Variable".length() + 3) {
                    maxAttLength = "Variable".length() + 3;
                }
                text.append("\n\nRegression Analysis:\n\n" + Utils.padRight("Variable", maxAttLength) + "  Coefficient     SE of Coef        t-Stat");
                column = 0;
                for (i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
                    if (i == this.m_ClassIndex || !this.m_SelectedAttributes[i]) continue;
                    text.append("\n" + Utils.padRight(this.m_TransformedData.attribute(i).name(), maxAttLength));
                    text.append(Utils.doubleToString(this.m_Coefficients[column], 12, this.m_numDecimalPlaces));
                    text.append("   " + Utils.doubleToString(this.m_StdErrorOfCoef[column], 12, this.m_numDecimalPlaces));
                    text.append("   " + Utils.doubleToString(this.m_TStats[column], 12, this.m_numDecimalPlaces));
                    ++column;
                }
                text.append(Utils.padRight("\nconst", maxAttLength + 1) + Utils.doubleToString(this.m_Coefficients[column], 12, this.m_numDecimalPlaces));
                text.append("   " + Utils.doubleToString(this.m_StdErrorOfCoef[column], 12, this.m_numDecimalPlaces));
                text.append("   " + Utils.doubleToString(this.m_TStats[column], 12, this.m_numDecimalPlaces));
                text.append("\n\nDegrees of freedom = " + Integer.toString(this.m_df));
                text.append("\nR^2 value = " + Utils.doubleToString(this.m_RSquared, this.m_numDecimalPlaces));
                text.append("\nAdjusted R^2 = " + Utils.doubleToString(this.m_RSquaredAdj, 5));
                text.append("\nF-statistic = " + Utils.doubleToString(this.m_FStat, this.m_numDecimalPlaces));
            }
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print Linear Regression!";
        }
    }

    @Override
    public Enumeration<Option> listOptions() {
        java.util.Vector<Option> newVector = new java.util.Vector<Option>();
        newVector.addElement(new Option("\tSet the attribute selection method to use. 1 = None, 2 = Greedy.\n\t(default 0 = M5' method)", "S", 1, "-S <number of selection method>"));
        newVector.addElement(new Option("\tDo not try to eliminate colinear attributes.\n", "C", 0, "-C"));
        newVector.addElement(new Option("\tSet ridge parameter (default 1.0e-8).\n", "R", 1, "-R <double>"));
        newVector.addElement(new Option("\tConserve memory, don't keep dataset header and means/stdevs.\n\tModel cannot be printed out if this option is enabled.\t(default: keep data)", "minimal", 0, "-minimal"));
        newVector.addElement(new Option("\tOutput additional statistics.", "additional-stats", 0, "-additional-stats"));
        newVector.addElement(new Option("\tUse QR decomposition to find coefficients", "use-qr", 0, "-use-qr"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    public double[] coefficients() {
        double[] coefficients = new double[this.m_SelectedAttributes.length + 1];
        int counter = 0;
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            if (!this.m_SelectedAttributes[i] || i == this.m_ClassIndex) continue;
            coefficients[i] = this.m_Coefficients[counter++];
        }
        coefficients[this.m_SelectedAttributes.length] = this.m_Coefficients[counter];
        return coefficients;
    }

    @Override
    public String[] getOptions() {
        java.util.Vector<String> result = new java.util.Vector<String>();
        result.add("-S");
        result.add("" + this.getAttributeSelectionMethod().getSelectedTag().getID());
        if (!this.getEliminateColinearAttributes()) {
            result.add("-C");
        }
        result.add("-R");
        result.add("" + this.getRidge());
        if (this.getMinimal()) {
            result.add("-minimal");
        }
        if (this.getOutputAdditionalStats()) {
            result.add("-additional-stats");
        }
        if (this.getUseQRDecomposition()) {
            result.add("-use-qr");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String selectionString = Utils.getOption('S', options);
        if (selectionString.length() != 0) {
            this.setAttributeSelectionMethod(new SelectedTag(Integer.parseInt(selectionString), TAGS_SELECTION));
        } else {
            this.setAttributeSelectionMethod(new SelectedTag(0, TAGS_SELECTION));
        }
        String ridgeString = Utils.getOption('R', options);
        if (ridgeString.length() != 0) {
            this.setRidge(new Double(ridgeString));
        } else {
            this.setRidge(1.0E-8);
        }
        this.setEliminateColinearAttributes(!Utils.getFlag('C', options));
        this.setMinimal(Utils.getFlag("minimal", options));
        this.setOutputAdditionalStats(Utils.getFlag("additional-stats", options));
        this.setUseQRDecomposition(Utils.getFlag("use-qr", options));
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    public String ridgeTipText() {
        return "The value of the Ridge parameter.";
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public void setRidge(double newRidge) {
        this.m_Ridge = newRidge;
    }

    public String eliminateColinearAttributesTipText() {
        return "Eliminate colinear attributes.";
    }

    public boolean getEliminateColinearAttributes() {
        return this.m_EliminateColinearAttributes;
    }

    public void setEliminateColinearAttributes(boolean newEliminateColinearAttributes) {
        this.m_EliminateColinearAttributes = newEliminateColinearAttributes;
    }

    public int numParameters() {
        return this.m_Coefficients.length - 1;
    }

    public String attributeSelectionMethodTipText() {
        return "Set the method used to select attributes for use in the linear regression. Available methods are: no attribute selection, attribute selection using M5's method (step through the attributes removing the one with the smallest standardised coefficient until no improvement is observed in the estimate of the error given by the Akaike information criterion), and a greedy selection using the Akaike information metric.";
    }

    public SelectedTag getAttributeSelectionMethod() {
        return new SelectedTag(this.m_AttributeSelection, TAGS_SELECTION);
    }

    public void setAttributeSelectionMethod(SelectedTag method) {
        if (method.getTags() == TAGS_SELECTION) {
            this.m_AttributeSelection = method.getSelectedTag().getID();
        }
    }

    public String minimalTipText() {
        return "If enabled, dataset header, means and stdevs get discarded to conserve memory; also, the model cannot be printed out.";
    }

    public boolean getMinimal() {
        return this.m_Minimal;
    }

    public void setMinimal(boolean value) {
        this.m_Minimal = value;
    }

    public String outputAdditionalStatsTipText() {
        return "Output additional statistics (such as std deviation of coefficients and t-statistics)";
    }

    public boolean getOutputAdditionalStats() {
        return this.m_outputAdditionalStats;
    }

    public void setOutputAdditionalStats(boolean additional) {
        this.m_outputAdditionalStats = additional;
    }

    public String useQRDecompositionTipText() {
        return "Use QR decomposition to find the coefficients";
    }

    public boolean getUseQRDecomposition() {
        return this.m_useQRDecomposition;
    }

    public void setUseQRDecomposition(boolean useQR) {
        this.m_useQRDecomposition = useQR;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    protected boolean deselectColinearAttributes(boolean[] selectedAttributes, double[] coefficients) {
        double maxSC = 1.5;
        int maxAttr = -1;
        int coeff = 0;
        for (int i = 0; i < selectedAttributes.length; ++i) {
            if (!selectedAttributes[i]) continue;
            double SC = Math.abs(coefficients[coeff] * this.m_StdDevs[i] / this.m_ClassStdDev);
            if (SC > maxSC) {
                maxSC = SC;
                maxAttr = i;
            }
            ++coeff;
        }
        if (maxAttr >= 0) {
            selectedAttributes[maxAttr] = false;
            if (this.m_Debug) {
                System.out.println("Deselected colinear attribute:" + (maxAttr + 1) + " with standardised coefficient: " + maxSC);
            }
            return true;
        }
        return false;
    }

    protected void findBestModel() throws Exception {
        int numInstances = this.m_TransformedData.numInstances();
        if (this.m_Debug) {
            System.out.println(new Instances(this.m_TransformedData, 0).toString());
        }
        do {
            this.m_Coefficients = this.doRegression(this.m_SelectedAttributes);
        } while (this.m_EliminateColinearAttributes && this.deselectColinearAttributes(this.m_SelectedAttributes, this.m_Coefficients));
        int numAttributes = 1;
        for (boolean m_SelectedAttribute : this.m_SelectedAttributes) {
            if (!m_SelectedAttribute) continue;
            ++numAttributes;
        }
        double fullMSE = this.calculateSE(this.m_SelectedAttributes, this.m_Coefficients);
        double akaike = numInstances - numAttributes + 2 * numAttributes;
        if (this.m_Debug) {
            System.out.println("Initial Akaike value: " + akaike);
        }
        int currentNumAttributes = numAttributes;
        switch (this.m_AttributeSelection) {
            case 2: {
                boolean improved;
                do {
                    boolean[] currentSelected = (boolean[])this.m_SelectedAttributes.clone();
                    improved = false;
                    --currentNumAttributes;
                    for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                        if (!currentSelected[i]) continue;
                        currentSelected[i] = false;
                        double[] currentCoeffs = this.doRegression(currentSelected);
                        double currentMSE = this.calculateSE(currentSelected, currentCoeffs);
                        double currentAkaike = currentMSE / fullMSE * (double)(numInstances - numAttributes) + (double)(2 * currentNumAttributes);
                        if (this.m_Debug) {
                            System.out.println("(akaike: " + currentAkaike);
                        }
                        if (currentAkaike < akaike) {
                            if (this.m_Debug) {
                                System.err.println("Removing attribute " + (i + 1) + " improved Akaike: " + currentAkaike);
                            }
                            improved = true;
                            akaike = currentAkaike;
                            System.arraycopy(currentSelected, 0, this.m_SelectedAttributes, 0, this.m_SelectedAttributes.length);
                            this.m_Coefficients = currentCoeffs;
                        }
                        currentSelected[i] = true;
                    }
                } while (improved);
                break;
            }
            case 0: {
                boolean improved;
                do {
                    improved = false;
                    --currentNumAttributes;
                    double minSC = 0.0;
                    int minAttr = -1;
                    int coeff = 0;
                    for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                        if (!this.m_SelectedAttributes[i]) continue;
                        double SC = Math.abs(this.m_Coefficients[coeff] * this.m_StdDevs[i] / this.m_ClassStdDev);
                        if (coeff == 0 || SC < minSC) {
                            minSC = SC;
                            minAttr = i;
                        }
                        ++coeff;
                    }
                    if (minAttr < 0) continue;
                    this.m_SelectedAttributes[minAttr] = false;
                    double[] currentCoeffs = this.doRegression(this.m_SelectedAttributes);
                    double currentMSE = this.calculateSE(this.m_SelectedAttributes, currentCoeffs);
                    double currentAkaike = currentMSE / fullMSE * (double)(numInstances - numAttributes) + (double)(2 * currentNumAttributes);
                    if (this.m_Debug) {
                        System.out.println("(akaike: " + currentAkaike);
                    }
                    if (currentAkaike < akaike) {
                        if (this.m_Debug) {
                            System.err.println("Removing attribute " + (minAttr + 1) + " improved Akaike: " + currentAkaike);
                        }
                        improved = true;
                        akaike = currentAkaike;
                        this.m_Coefficients = currentCoeffs;
                        continue;
                    }
                    this.m_SelectedAttributes[minAttr] = true;
                } while (improved);
                break;
            }
        }
    }

    protected double calculateSE(boolean[] selectedAttributes, double[] coefficients) throws Exception {
        double mse = 0.0;
        for (int i = 0; i < this.m_TransformedData.numInstances(); ++i) {
            double prediction = this.regressionPrediction(this.m_TransformedData.instance(i), selectedAttributes, coefficients);
            double error = prediction - this.m_TransformedData.instance(i).classValue();
            mse += error * error;
        }
        return mse;
    }

    protected double regressionPrediction(Instance transformedInstance, boolean[] selectedAttributes, double[] coefficients) throws Exception {
        double result = 0.0;
        int column = 0;
        for (int j = 0; j < transformedInstance.numAttributes(); ++j) {
            if (this.m_ClassIndex == j || !selectedAttributes[j]) continue;
            result += coefficients[column] * transformedInstance.value(j);
            ++column;
        }
        return result += coefficients[column];
    }

    /*
     * WARNING - void declaration
     */
    protected double[] doRegression(boolean[] selectedAttributes) throws Exception {
        void var5_10;
        if (this.m_Debug) {
            System.out.print("doRegression(");
            for (boolean bl : selectedAttributes) {
                System.out.print(" " + bl);
            }
            System.out.println(" )");
        }
        int numAttributes = 0;
        boolean[] blArray = selectedAttributes;
        int n = blArray.length;
        boolean bl = false;
        while (var5_10 < n) {
            boolean selectedAttribute = blArray[var5_10];
            if (selectedAttribute) {
                ++numAttributes;
            }
            ++var5_10;
        }
        DenseMatrix independentTransposed = null;
        DenseMatrix independent = null;
        Object var5_11 = null;
        if (numAttributes > 0) {
            if (!this.m_useQRDecomposition) {
                independentTransposed = new DenseMatrix(numAttributes, this.m_TransformedData.numInstances());
                DenseVector denseVector = new DenseVector(this.m_TransformedData.numInstances());
            } else if (this.m_Ridge <= 0.0) {
                independent = new DenseMatrix(this.m_TransformedData.numInstances(), numAttributes);
                DenseVector denseVector = new DenseVector(this.m_TransformedData.numInstances());
            } else {
                independent = new DenseMatrix(this.m_TransformedData.numInstances() + numAttributes, numAttributes);
                DenseVector denseVector = new DenseVector(this.m_TransformedData.numInstances() + numAttributes);
            }
            for (int i = 0; i < this.m_TransformedData.numInstances(); ++i) {
                Instance inst = this.m_TransformedData.instance(i);
                double sqrt_weight = Math.sqrt(inst.weight());
                int index = 0;
                for (int j = 0; j < this.m_TransformedData.numAttributes(); ++j) {
                    if (j == this.m_ClassIndex) {
                        void var5_15;
                        var5_15.set(i, inst.classValue() * sqrt_weight);
                        continue;
                    }
                    if (!selectedAttributes[j]) continue;
                    double value = inst.value(j) - this.m_Means[j];
                    if (!this.m_checksTurnedOff) {
                        value /= this.m_StdDevs[j];
                    }
                    if (!this.m_useQRDecomposition) {
                        independentTransposed.set(index, i, value * sqrt_weight);
                    } else {
                        independent.set(i, index, value * sqrt_weight);
                    }
                    ++index;
                }
            }
        }
        if (this.m_useQRDecomposition && this.m_Ridge > 0.0) {
            double sqrtRidge = Math.sqrt(this.m_Ridge);
            for (int i = 0; i < numAttributes; ++i) {
                independent.set(this.m_TransformedData.numInstances() + i, i, sqrtRidge);
            }
        }
        double[] coefficients = new double[numAttributes + 1];
        if (numAttributes > 0) {
            void var5_16;
            if (!this.m_useQRDecomposition) {
                Vector aTy = independentTransposed.mult((Vector)var5_16, (Vector)new DenseVector(numAttributes));
                Matrix aTa = new UpperSPDDenseMatrix(numAttributes).rank1((Matrix)independentTransposed);
                independentTransposed = null;
                Object var5_17 = null;
                double ridge = this.getRidge();
                for (int i = 0; i < numAttributes; ++i) {
                    aTa.add(i, i, ridge);
                }
                Vector coeffsWithoutIntercept = aTa.solve(aTy, (Vector)new DenseVector(numAttributes));
                System.arraycopy(((DenseVector)coeffsWithoutIntercept).getData(), 0, coefficients, 0, numAttributes);
            } else {
                QRP qrp = QRP.factorize(independent);
                independent = null;
                DenseMatrix Q = qrp.getQ();
                UpperTriangDenseMatrix R = new UpperTriangDenseMatrix((Matrix)qrp.getR(), false);
                Matrix P = qrp.getP();
                DenseVector cPlusd = (DenseVector)Q.transMult((Vector)var5_16, (Vector)new DenseVector(var5_16.size()));
                Object var5_18 = null;
                DenseVector c = new DenseVector(Arrays.copyOf(cPlusd.getData(), numAttributes));
                Vector y = R.solve((Vector)c, (Vector)new DenseVector(numAttributes));
                Vector coeffsWithoutIntercept = P.mult(y, (Vector)new DenseVector(numAttributes));
                System.arraycopy(((DenseVector)coeffsWithoutIntercept).getData(), 0, coefficients, 0, numAttributes);
            }
        }
        coefficients[numAttributes] = this.m_ClassMean;
        int column = 0;
        for (int i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
            if (i == this.m_TransformedData.classIndex() || !selectedAttributes[i]) continue;
            if (!this.m_checksTurnedOff) {
                int n2 = column;
                coefficients[n2] = coefficients[n2] / this.m_StdDevs[i];
            }
            int n3 = coefficients.length - 1;
            coefficients[n3] = coefficients[n3] - coefficients[column] * this.m_Means[i];
            ++column;
        }
        return coefficients;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14872 $");
    }
}

