/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.ConceptSetSelection;
import org.ohdsi.circe.cohortdefinition.DateAdjustment;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class VisitDetailSqlBuilder<T extends VisitDetail>
extends CriteriaSqlBuilder<T> {
    private static final String VISIT_DETAIL_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/visitDetail.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_DETAIL_ID));
    private final List<String> DEFAULT_SELECT_COLUMNS = new ArrayList<String>(Arrays.asList("vd.person_id", "vd.visit_detail_id", "vd.visit_detail_concept_id", "vd.visit_occurrence_id"));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return VISIT_DETAIL_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.visit_detail_concept_id";
            }
            case DURATION: {
                return "DATEDIFF(d, C.start_date, C.end_date)";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Visit Detail:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((VisitDetail)criteria).codesetId, "vd.visit_detail_concept_id", ((VisitDetail)criteria).visitDetailSourceConcept, "vd.visit_detail_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((VisitDetail)criteria).first != null && ((VisitDetail)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY vd.person_id ORDER BY vd.visit_detail_start_date, vd.visit_detail_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveSelectClauses(T criteria) {
        ArrayList<String> selectCols = new ArrayList<String>(this.DEFAULT_SELECT_COLUMNS);
        if (((VisitDetail)criteria).visitDetailTypeCS != null && ((VisitDetail)criteria).visitDetailTypeCS.codesetId != null) {
            selectCols.add("vd.visit_detail_type_concept_id");
        }
        if (((VisitDetail)criteria).providerSpecialtyCS != null && ((VisitDetail)criteria).providerSpecialtyCS.codesetId != null) {
            selectCols.add("vd.provider_id");
        }
        if (((VisitDetail)criteria).placeOfServiceCS != null && ((VisitDetail)criteria).placeOfServiceCS.codesetId != null) {
            selectCols.add("vd.care_site_id");
        }
        if (((VisitDetail)criteria).dateAdjustment != null) {
            selectCols.add(BuilderUtils.getDateAdjustmentExpression(((VisitDetail)criteria).dateAdjustment, ((VisitDetail)criteria).dateAdjustment.startWith == DateAdjustment.DateType.START_DATE ? "vd.visit_detail_start_date" : "vd.visit_detail_end_date", ((VisitDetail)criteria).dateAdjustment.endWith == DateAdjustment.DateType.START_DATE ? "vd.visit_detail_start_date" : "vd.visit_detail_end_date"));
        } else {
            selectCols.add("vd.visit_detail_start_date as start_date, vd.visit_detail_end_date as end_date");
        }
        return selectCols;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((VisitDetail)criteria).age != null || ((VisitDetail)criteria).genderCS != null) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((VisitDetail)criteria).placeOfServiceCS != null || ((VisitDetail)criteria).placeOfServiceLocation != null) {
            joinClauses.add("JOIN @cdm_database_schema.CARE_SITE CS on C.care_site_id = CS.care_site_id");
        }
        if (((VisitDetail)criteria).providerSpecialtyCS != null) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        if (((VisitDetail)criteria).placeOfServiceLocation != null) {
            this.addFilteringByCareSiteLocationRegion(joinClauses, ((VisitDetail)criteria).placeOfServiceLocation);
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        List<String> whereClauses = super.resolveWhereClauses(criteria);
        if (((VisitDetail)criteria).visitDetailStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.start_date", ((VisitDetail)criteria).visitDetailStartDate));
        }
        if (((VisitDetail)criteria).visitDetailEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.end_date", ((VisitDetail)criteria).visitDetailEndDate));
        }
        if (((VisitDetail)criteria).visitDetailTypeCS != null && ((VisitDetail)criteria).visitDetailTypeCS.codesetId != null) {
            this.addWhereClause(whereClauses, ((VisitDetail)criteria).visitDetailTypeCS, "C.visit_detail_type_concept_id");
        }
        if (((VisitDetail)criteria).visitDetailLength != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("DATEDIFF(d,C.start_date, C.end_date)", ((VisitDetail)criteria).visitDetailLength));
        }
        if (((VisitDetail)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.end_date) - P.year_of_birth", ((VisitDetail)criteria).age));
        }
        if (((VisitDetail)criteria).genderCS != null && ((VisitDetail)criteria).genderCS.codesetId != null) {
            this.addWhereClause(whereClauses, ((VisitDetail)criteria).genderCS, "P.gender_concept_id");
        }
        if (((VisitDetail)criteria).providerSpecialtyCS != null && ((VisitDetail)criteria).providerSpecialtyCS.codesetId != null) {
            this.addWhereClause(whereClauses, ((VisitDetail)criteria).providerSpecialtyCS, "PR.specialty_concept_id");
        }
        if (((VisitDetail)criteria).placeOfServiceCS != null && ((VisitDetail)criteria).placeOfServiceCS.codesetId != null) {
            this.addWhereClause(whereClauses, ((VisitDetail)criteria).placeOfServiceCS, "CS.place_of_service_concept_id");
        }
        return whereClauses;
    }

    protected void addFilteringByCareSiteLocationRegion(List<String> joinClauses, Integer codesetId) {
        joinClauses.add(this.getLocationHistoryJoin("LH", "CARE_SITE", "C.care_site_id"));
        joinClauses.add("JOIN @cdm_database_schema.LOCATION LOC on LOC.location_id = LH.location_id");
        this.addFiltering(joinClauses, codesetId, "LOC.region_concept_id");
    }

    private void addWhereClause(List<String> whereClauses, ConceptSetSelection conceptSetSelection, String conceptColumn) {
        whereClauses.add(String.format("%s %s in (select concept_id from #Codesets where codeset_id = %s)", conceptColumn, conceptSetSelection.isExclusion != false ? "not" : "", conceptSetSelection.codesetId));
    }

    private void addFiltering(List<String> joinClauses, Integer codesetId, String standardConceptColumn) {
        joinClauses.add(BuilderUtils.getCodesetJoinExpression(codesetId, standardConceptColumn, null, null));
    }

    protected String getLocationHistoryJoin(String alias, String domain, String entityIdField) {
        return "JOIN @cdm_database_schema.LOCATION_HISTORY " + alias + " on " + alias + ".entity_id = " + entityIdField + " AND " + alias + ".domain_id = '" + domain + "' AND C.visit_detail_start_date >= " + alias + ".start_date AND C.visit_detail_end_date <= ISNULL(" + alias + ".end_date, DATEFROMPARTS(2099,12,31))";
    }
}

