/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.rnd;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.attributeIndicators.J48NodeIndicators;
import dmLab.classifier.rnd.RNDParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import java.io.IOException;
import java.util.Random;

public final class RNDClassifier
extends Classifier {
    private RNDParams cfg;
    private Random rand;
    private FArray trainArray;

    public RNDClassifier() {
        this.label = labels[RND];
        this.model = RND;
        this.params = new RNDParams();
        this.cfg = (RNDParams)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean train(FArray trainArray) {
        void var1_2;
        void var2_3;
        this.trainArray = trainArray;
        float start = System.currentTimeMillis();
        this.rand = new Random((long)this.cfg.seed);
        float stop = System.currentTimeMillis();
        this.learningTime = (float)((double)(var2_3 - var1_2) / 1000.0);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_3;
        void var1_2;
        float start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), ((Array)testArray).getDecValuesStr());
        int testEventsNumber = ((Array)testArray).rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        for (int i = 0; i < testEventsNumber; ++i) {
            void var3_7;
            int n = i;
            Object object = testArray;
            RNDClassifier rNDClassifier = this;
            int n2 = -1;
            double d = 0.0;
            object = ((FArray)object).getDecValues();
            for (int j = 0; j < ((Object)object).length; ++j) {
                double d2;
                RNDClassifier rNDClassifier2 = rNDClassifier;
                double d3 = rNDClassifier2.rand.nextDouble();
                if (!(d2 > d)) continue;
                n2 = j;
                d = d3;
            }
            float predictedDecision = d > 0.0 ? (float)object[n2] : -1.0f;
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, (String)var3_7, null);
        }
        float stop = System.currentTimeMillis();
        this.testingTime = (float)((double)(var1_2 - var2_3) / 1000.0);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        void var3_6;
        void var2_4;
        void var1_1;
        int idx22 = -1;
        int decisionAttrIndex = this.trainArray.getDecAttrIdx();
        while (idx22 == decisionAttrIndex) {
            FArray idx22 = this.trainArray;
            idx22 = this.rand.nextInt(idx22.attributes.length);
        }
        String name = this.trainArray.attributes[idx22].name;
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = QualityMeasure.calcWAcc(this.predResult.confusionMatrix.getMatrix());
        var1_1[0].addImportances((String)var2_4, (ExperimentIndicators)var3_6, new J48NodeIndicators(0));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var2_2;
        void var1_1;
        this.params.save((String)var1_1, (String)var2_2);
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(" ### RND Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        return var1_1.toString();
    }
}

