# enpls 6.1.1

## Improvements

- Use GitHub Actions workflow to build pkgdown website (#2).
- Fix `R CMD check` notes for r-devel on the invalid file URIs in `README.md` (#2).

# enpls 6.1

## Improvements

- Switched to the tidyverse code style.
- Updated the vignette style.
- Updated GitHub repository links due to the handle change.

# enpls 6.0

## Improvements

- New URL for the documentation website: https://nanx.me/enpls/.

# enpls 5.9

## Improvements

- Use system font stack instead of Google Fonts in vignettes to avoid pandoc SSL issue.

# enpls 5.8

## Improvements

- Updated gallery images in `README.md`.
- Better code indentation style.
- HTTPS enabled for the website.

# enpls 5.7

## Improvements

- New documentation website generated by pkgdown,
  with a full set of function documentation and vignettes available.
- Added Windows continuous integration support using AppVeyor.

# enpls 5.6

## New Features

- New argument `cvfolds` now available in all applicable functions for finer control of cross-validation folds in automatic parameter selection of each PLS/SPLS model.

## Improvements

- Critical implementation improvements for processing the case where argument `maxcomp = NULL` (maximum number of components not specified explicitly) in `enpls.` functions. Now it should correctly determine the maximum number of components to use, considering both cross-validation and special cases such as n < p. Thanks to Dr. You-Wu Lin for the feedback.

# enpls 5.0

## New Features

- New functions `enpls.ad()` and `enspls.ad()` for PLS and sparse PLS model applicability domain evaluation.
- New plot functions `plot.enpls.ad()` and `plot.enpls.ad()` for exploring model applicability domain evaluation results with traditional static plot support and interactive plot support.
- New argument `alpha` available for setting transparency level (to reduce overplotting) in `plot.cv.enpls`, `plot.enpls.od`, `plot.cv.enspls`, and `plot.enspls.od`.

# enpls 4.5

## Improvements

- Reduced memory footprints for `enpls.fit()` and `enspls.fit()`.

## New Features

- New functions `enpls.rmse()`, `enpls.mae()`, and `enpls.rmsle()` for computing RMSE, MAE, and RMSLE.

# enpls 4.0

## Improvements

- General improvements on function documentation.
- Changing the argument name `MCtimes` to `reptimes`.
- Changing the option name `"bootstrap"` to `"boot"`.

# enpls 3.0

## New Features

- Add sparse partial least squares regression.

## Improvements

- Improvements on documentation; rewritten vignette.

# enpls 2.0

## New Features

- New project website.

## Improvements

- General improvements on plotting functions.

## Bug Fixes

- Fixed major bugs in `cv.enpls` and plotting functions.
- Many other bug fixes.

# enpls 1.1

##  Bug Fixes

- Fixed the bugs in automatic component number selection which could make
the intercept-only model rank best. Thanks for the test and patch from
Max Kuhn <<max.kuhn@pfizer.com>>.

# enpls 1.0

## New Features

- initial release
