/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data;

public enum DataType {
    BOOLEAN(1, "Boolean", "B"),
    SHORT(2, "Short", "T"),
    INTEGER(78, "Integer", "I"),
    LONG(8, "Long", "L"),
    FLOAT(16, "Float", "F"),
    DOUBLE(32, "Double", "D"),
    BIG_INTEGER(64, "Big Integer", "R"),
    BIG_DECIMAL(128, "Big Decimal", "M"),
    DATE(256, "Date", "A"),
    STRING(512, "String", "S"),
    SIMPLE_ENTRY(1024, "SimpleEntry", "E"),
    UNKNOWN(0, "None", "X");

    private static final DataType[] allTypes;
    private String name;
    private String abbreviation;
    private int id;

    private DataType(int id, String name, String abbreviation) {
        this.id = id;
        this.name = name;
        this.abbreviation = abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public final String getAbbreviation() {
        return this.abbreviation;
    }

    public final synchronized int getId() {
        return this.id;
    }

    public static final DataType[] getAllTypes() {
        return allTypes;
    }

    public static final DataType getTypeByName(String name) {
        DataType dataType = null;
        for (int i = 0; i < allTypes.length; ++i) {
            if (!allTypes[i].getName().equals(name)) continue;
            dataType = allTypes[i];
        }
        return dataType;
    }

    public static final DataType getTypeByAbbreviation(String abbreviation) {
        DataType dataType = null;
        for (int i = 0; i < allTypes.length; ++i) {
            if (!allTypes[i].getAbbreviation().equals(abbreviation)) continue;
            dataType = allTypes[i];
        }
        return dataType;
    }

    public static final DataType getDataTypeById(int id) {
        DataType dataType = null;
        for (int i = 0; i < allTypes.length; ++i) {
            if (allTypes[i].getId() != id) continue;
            dataType = allTypes[i];
        }
        return dataType;
    }

    static {
        allTypes = new DataType[]{BOOLEAN, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIG_INTEGER, BIG_DECIMAL, DATE, STRING};
    }
}

