## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, warning=FALSE, message=FALSE--------------------------------------
library(ECOTOXr)

## ----eval = FALSE-------------------------------------------------------------
# search_ecotox(
#   list(
#     latin_name    = list(terms = "Daphnia magna", method = "exact"),
#     chemical_name = list(terms = "benzene",       method = "exact")
#   )
# )

## ----eval = FALSE, warning = FALSE--------------------------------------------
# search_ecotox(
#   list(
#     result_id = list(terms = "401386", method = "exact")
#   ),
#   as_data_frame = F
# )

## ----eval = FALSE, warning = FALSE--------------------------------------------
# con <- dbConnectEcotox()
# dplyr::tbl(con, "results") |>
#   dplyr::filter(result_id == "401386") |>
#   dplyr::collect()

## ----eval = FALSE, warning = FALSE--------------------------------------------
# dbGetQuery(con, "SELECT * FROM results WHERE result_id='401386'") |>
#   dplyr::as_tibble()

## ----eval = FALSE-------------------------------------------------------------
# search_ecotox(
#   list(
#     test_cas   = list(terms = "71432",         method = "exact"),
#     latin_name = list(terms = "Daphnia magna", method = "exact")
#   )
# )

## ----eval = FALSE-------------------------------------------------------------
# tryCatch({
#   search_fields <-
#     list_ecotox_web_fields(
#       txAdvancedSpecEntries     = "daphnia magna",
#       RBSPECSEARCHTYPE          = "EXACT",
#       txAdvancedChemicalEntries = "benzene",
#       RBCHEMSEARCHTYPE          = "EXACT")
# 
#   search_results <- websearch_ecotox(search_fields, verify_ssl = FALSE)
# 
#   search_results$`Aquatic-Export`
# })
# 
# #> # A tibble: 56 × 87
# #>    `CAS Number` `Chemical Name` `Chemical Grade` `Chemical Analysis`
# #>           <dbl> <chr>           <chr>            <chr>
# #>  1        71432 Benzene         NA               NA
# #>  2        71432 Benzene         NA               NA
# #>  3        71432 Benzene         NA               Unmeasured
# #>  4        71432 Benzene         NA               Unmeasured
# #>  5        71432 Benzene         NA               Unmeasured
# #>  6        71432 Benzene         NA               Unmeasured
# #>  7        71432 Benzene         NA               Unmeasured
# #>  8        71432 Benzene         NA               Measured
# #>  9        71432 Benzene         NA               Unmeasured
# #> 10        71432 Benzene         NA               Unmeasured
# #> # ℹ 46 more rows
# #> # ℹ 83 more variables: `Chemical Purity Mean Op` <chr>,
# #> #   `Chemical Purity Mean(%)` <dbl>, `Chemical Purity Min Op` <lgl>,
# #> #   `Chemical Purity Min(%)` <lgl>, `Chemical Purity Max Op` <lgl>,
# #> #   `Chemical Purity Max(%)` <lgl>, `Species Scientific Name` <chr>,
# #> #   `Species Common Name` <chr>, `Species Group` <chr>,
# #> #   `Organism Lifestage` <chr>, `Organism Age Mean Op` <chr>, …

