/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.util.intset;

import net.sf.jclec.IConfigure;
import net.sf.jclec.util.intset.Closure;
import net.sf.jclec.util.intset.IIntegerSet;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Interval
implements IIntegerSet,
IConfigure {
    private static final long serialVersionUID = 4742142066614454991L;
    protected int left;
    protected int right;
    protected Closure closure;

    public Interval() {
    }

    public Interval(int left, int right, Closure closure) {
        this.setClosure(closure);
        this.setLeft(left);
        this.setRight(right);
    }

    public Closure getClosure() {
        return this.closure;
    }

    public void setClosure(Closure closure) {
        this.closure = closure;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public boolean contains(int value) {
        switch (this.closure) {
            case OpenOpen: {
                return value > this.left && value < this.right;
            }
            case OpenClosed: {
                return value > this.left && value <= this.right;
            }
            case ClosedOpen: {
                return value >= this.left && value < this.right;
            }
            case ClosedClosed: {
                return value >= this.left && value <= this.right;
            }
        }
        return false;
    }

    public int size() {
        return this.efRight() - this.efLeft();
    }

    public int getRandom(IRandGen randgen) {
        return randgen.choose(this.rndLeft(), this.rndRight());
    }

    public void configure(Configuration configuration) {
        Closure closure;
        int left = configuration.getInt("[@left]");
        this.setLeft(left);
        int right = configuration.getInt("[@right]");
        this.setRight(right);
        String closureString = configuration.getString("[@closure]", "closed-closed");
        if (closureString.equals("closed-closed")) {
            closure = Closure.ClosedClosed;
        } else if (closureString.equals("open-open")) {
            closure = Closure.OpenOpen;
        } else if (closureString.equals("closed-open")) {
            closure = Closure.ClosedOpen;
        } else if (closureString.equals("open-closed")) {
            closure = Closure.OpenClosed;
        } else {
            throw new ConfigurationRuntimeException("Illegal value for interval closure");
        }
        this.setClosure(closure);
    }

    public boolean equals(Object other) {
        if (other instanceof Interval) {
            Interval cother = (Interval)other;
            return this.closure == cother.closure && this.left == cother.left && this.right == cother.right;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder(this);
        tsb.append((Object)this.closure);
        tsb.append("left", this.left);
        tsb.append("right", this.right);
        return tsb.toString();
    }

    private final int efLeft() {
        switch (this.closure) {
            case OpenOpen: 
            case OpenClosed: {
                return this.left + 1;
            }
            case ClosedOpen: 
            case ClosedClosed: {
                return this.left;
            }
        }
        return 0;
    }

    private final int efRight() {
        switch (this.closure) {
            case OpenOpen: 
            case ClosedOpen: {
                return this.right - 1;
            }
            case OpenClosed: 
            case ClosedClosed: {
                return this.right;
            }
        }
        return 0;
    }

    private final int rndLeft() {
        switch (this.closure) {
            case OpenOpen: 
            case OpenClosed: {
                return this.left + 1;
            }
            case ClosedOpen: 
            case ClosedClosed: {
                return this.left;
            }
        }
        return 0;
    }

    private final int rndRight() {
        switch (this.closure) {
            case OpenOpen: 
            case ClosedOpen: {
                return this.right;
            }
            case OpenClosed: 
            case ClosedClosed: {
                return this.right + 1;
            }
        }
        return 0;
    }
}

