/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class ComboBoxWidget
extends JPanel
implements DeducerWidget {
    private JComboBox comboBox;
    private String title;
    private DefaultComboBoxModel model;
    private String initialModel;
    private String lastModel;

    public ComboBoxWidget(String string, String[] stringArray) {
        this.model = new DefaultComboBoxModel<String>(stringArray);
        this.title = string;
        this.initGUI();
    }

    public ComboBoxWidget(String[] stringArray) {
        this(null, stringArray);
    }

    private void initGUI() {
        try {
            BorderLayout borderLayout = new BorderLayout();
            this.setLayout(borderLayout);
            this.setPreferredSize(new Dimension(151, 21));
            if (this.title != null) {
                this.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            this.comboBox = new JComboBox();
            this.add((Component)this.comboBox, "Center");
            this.comboBox.setModel(this.model);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    public void addListener(EventListener eventListener) {
        if (eventListener instanceof ActionListener) {
            this.comboBox.addActionListener((ActionListener)eventListener);
        }
        if (eventListener instanceof MouseListener) {
            this.comboBox.addMouseListener((MouseListener)eventListener);
        }
        if (eventListener instanceof ItemListener) {
            this.comboBox.addItemListener((ItemListener)eventListener);
        }
    }

    @Override
    public Object getModel() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public String getRModel() {
        return "\"" + Deducer.addSlashes(this.comboBox.getSelectedItem().toString()) + "\"";
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void reset() {
        this.setModel(this.initialModel);
    }

    @Override
    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    @Override
    public void setDefaultModel(Object object) {
        this.initialModel = (String)object;
        if (this.lastModel == null) {
            this.lastModel = (String)object;
        }
    }

    @Override
    public void setLastModel(Object object) {
        this.lastModel = (String)object;
    }

    @Override
    public void setModel(Object object) {
        if (object == null) {
            this.comboBox.setSelectedIndex(0);
        }
        this.comboBox.setSelectedItem(object);
    }

    @Override
    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    @Override
    public void setTitle(String string) {
        this.setTitle(string, false);
    }
}

