/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.delta.SetGraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.set.SetGraphView;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class SetSuccessorsGraphView<E extends GraphVar<?>>
extends SetGraphView<E> {
    protected int node;
    protected IGraphDeltaMonitor gdm;
    protected PairProcedure arcRemoved;
    protected PairProcedure arcEnforced;

    public SetSuccessorsGraphView(String name, E graphVar, int node) {
        super(name, graphVar);
        this.node = node;
        this.gdm = graphVar.monitorDelta(this);
        this.gdm.startMonitoring();
        if (!graphVar.isDirected()) {
            this.arcRemoved = (from, to) -> {
                if (from == node || to == node) {
                    this.notifyPropagators(SetEventType.REMOVE_FROM_ENVELOPE, this);
                }
            };
            this.arcEnforced = (from, to) -> {
                if (from == node || to == node) {
                    this.notifyPropagators(SetEventType.ADD_TO_KER, this);
                }
            };
        } else {
            this.arcRemoved = (from, to) -> {
                if (from == node) {
                    this.notifyPropagators(SetEventType.REMOVE_FROM_ENVELOPE, this);
                }
            };
            this.arcEnforced = (from, to) -> {
                if (from == node) {
                    this.notifyPropagators(SetEventType.ADD_TO_KER, this);
                }
            };
        }
    }

    public SetSuccessorsGraphView(E graphVar, int node) {
        this("SUCCESSORS_OF(" + graphVar.getName() + ", " + node + ")", graphVar, node);
    }

    @Override
    public ISet getLB() {
        return this.graphVar.getMandatorySuccessorsOf(this.node);
    }

    @Override
    public ISet getUB() {
        return this.graphVar.getPotentialSuccessorsOf(this.node);
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        for (int i : value) {
            this.force(i, cause);
        }
        if (this.getLB().size() != value.length) {
            this.contradiction(cause, this.getName() + " cannot be instantiated to " + Arrays.toString(value));
        }
        if (this.getUB().size() != value.length) {
            Object object = this.getUB().iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                if (this.getLB().contains(i)) continue;
                this.remove(i, cause);
            }
        }
        return changed;
    }

    @Override
    public boolean isInstantiated() {
        return this.getLB().size() == this.getUB().size();
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        return this.graphVar.removeEdge(this.node, element, this);
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        return this.graphVar.enforceEdge(this.node, element, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (event == GraphEventType.REMOVE_EDGE) {
            this.gdm.forEachEdge(this.arcRemoved, GraphEventType.REMOVE_EDGE);
        }
        if (event == GraphEventType.ADD_EDGE) {
            this.gdm.forEachEdge(this.arcEnforced, GraphEventType.ADD_EDGE);
        }
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new SetGraphViewDeltaMonitor(this.graphVar.monitorDelta(propagator)){

            @Override
            public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
                PairProcedure filter = (from, to) -> {
                    if (from == SetSuccessorsGraphView.this.node) {
                        proc.execute(to);
                    }
                };
                if (evt == SetEventType.ADD_TO_KER) {
                    this.deltaMonitor.forEachEdge(filter, GraphEventType.ADD_EDGE);
                } else if (evt == SetEventType.REMOVE_FROM_ENVELOPE) {
                    this.deltaMonitor.forEachEdge(filter, GraphEventType.REMOVE_EDGE);
                }
            }
        };
    }
}

