/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.jpmml.evaluator.Function;
import org.jpmml.evaluator.FunctionRegistry;
import org.jpmml.rexp.evaluator.functions.PPois;

public class RExpFunctionRegistry {
    private static final Map<String, Function> rexpFunctions;
    private static final Map<String, Class<? extends Function>> rexpFunctionClazzes;

    private RExpFunctionRegistry() {
    }

    public static void publish(String name) {
        RExpFunctionRegistry.publish((String key) -> Objects.equals(name, key));
    }

    public static void publishAll() {
        RExpFunctionRegistry.publish((String key) -> true);
    }

    private static void publish(Predicate<String> predicate) {
        rexpFunctions.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Function)((Function)entry.getValue())));
        rexpFunctionClazzes.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).forEach(entry -> FunctionRegistry.putFunction((String)((String)entry.getKey()), (Class)((Class)entry.getValue())));
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"stats::ppois", (Object)new PPois());
        rexpFunctions = builder.build();
        rexpFunctionClazzes = Collections.emptyMap();
    }
}

