/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.sat.MiniSat;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.OneValueDelta;
import org.chocosolver.solver.variables.delta.monitor.OneValueDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.LitVar;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.iterators.IntVarValueIterator;

@Explained
public class BoolVarEagerLit
extends AbstractVariable
implements BoolVar,
LitVar {
    MiniSat sat;
    boolean channeling = true;
    int vlit;
    private IEnumDelta delta = NoDelta.singleton;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private IntVarValueIterator _javaIterator;
    private boolean reactOnRemoval = false;
    private BoolVar not;
    private boolean isNot = false;
    int type;

    public BoolVarEagerLit(String name, Model model, int min, int max) {
        super(name, model);
        this.sat = this.getModel().getSolver().getSat();
        this.vlit = MiniSat.makeLiteral(this.sat.nVars(), true);
        this.sat.newVariable(new MiniSat.ChannelInfo(this, 1, 0, 1));
        int t = 1;
        if (min == 1) {
            this.sat.cEnqueue(this.vlit, Reason.undef());
            t = 2;
        }
        if (max == 0) {
            this.sat.cEnqueue(MiniSat.neg(this.vlit), Reason.undef());
            t = 2;
        }
        this.type = t;
    }

    @Override
    public boolean removeValue(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        if (value == 0) {
            return this.instantiateTo(1, cause, reason);
        }
        if (value == 1) {
            return this.instantiateTo(0, cause, reason);
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause, Reason reason) throws ContradictionException {
        if (!this.channeling) {
            this.channeling = true;
            if (this.sat.confl != MiniSat.C_Undef) {
                this.contradiction(cause, "sat failure");
            }
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        if (!this.isInstantiatedTo(value)) {
            int cval;
            boolean inconsistent = this.isInstantiated() || value < 0 || value > 1;
            this.notify(reason, cause, this.sat, this.getLit(value, 1));
            if (inconsistent) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            if ((cval = this.sat.valueLit(this.vlit)) == 1 && value != 1 || cval == 2 && value != 0) {
                assert (this.sat.confl != MiniSat.C_Undef);
                this.contradiction(cause, "sat failure");
            }
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        return value > 0 && this.instantiateTo(value, cause, reason);
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause, Reason reason) throws ContradictionException {
        assert (cause != null);
        return value < 1 && this.instantiateTo(value, cause, reason);
    }

    @Override
    public void channel(int val, int val_type, int sign) {
        block6: {
            this.channeling = false;
            int op = val_type * 3 ^ sign;
            try {
                switch (op) {
                    case 0: {
                        this.removeValue(val, Cause.Null, Reason.undef());
                        break;
                    }
                    case 1: {
                        this.instantiateTo(val, Cause.Null, Reason.undef());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("BoolVarEagerLit#channel");
                    }
                }
            }
            catch (ContradictionException ce) {
                if ($assertionsDisabled || this.sat.confl != MiniSat.C_Undef) break block6;
                throw new AssertionError();
            }
        }
        this.channeling = true;
    }

    @Override
    public int getLit(int val, int type) {
        if (val < 0) {
            return 1 ^ type & 1;
        }
        if (val > 1) {
            return type - 1 >> 1 & 1;
        }
        switch (type) {
            case 0: {
                return this.vlit - val;
            }
            case 1: {
                return this.vlit - 1 + val;
            }
            case 2: {
                return val == 1 ? this.vlit - 1 + val : 1;
            }
            case 3: {
                return val == 0 ? this.vlit - 1 + val : 1;
            }
        }
        throw new UnsupportedOperationException("BoolVarEagerLit#getLit");
    }

    @Override
    public int getMinLit() {
        return MiniSat.neg(this.getLit(this.getLB(), 2));
    }

    @Override
    public int getMaxLit() {
        return MiniSat.neg(this.getLit(this.getUB(), 3));
    }

    @Override
    public int getValLit() {
        assert (this.isInstantiated()) : this + " is not instantiated";
        return this.getLit(this.getLB(), 0);
    }

    @Override
    public boolean isInstantiated() {
        return this.sat.valueLit(this.vlit) != 3;
    }

    @Override
    public boolean isInstantiatedTo(int aValue) {
        switch (this.sat.valueLit(this.vlit)) {
            case 1: {
                return aValue == 1;
            }
            case 2: {
                return aValue == 0;
            }
        }
        return false;
    }

    @Override
    public boolean contains(int aValue) {
        switch (this.sat.valueLit(this.vlit)) {
            case 1: {
                return aValue == 1;
            }
            case 2: {
                return aValue == 0;
            }
        }
        return aValue == 0 || aValue == 1;
    }

    @Override
    public int getValue() throws IllegalStateException {
        if (!this.isInstantiated()) {
            throw new IllegalStateException("getValue() can be only called on instantiated variable. " + this.name + " is not instantiated");
        }
        return this.getLB();
    }

    @Override
    public ESat getBooleanValue() {
        if (this.isInstantiated()) {
            return ESat.eval(this.getLB() != 0);
        }
        return ESat.UNDEFINED;
    }

    @Override
    public int getLB() {
        switch (this.sat.valueLit(this.vlit)) {
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int getUB() {
        switch (this.sat.valueLit(this.vlit)) {
            default: {
                return 1;
            }
            case 2: 
        }
        return 0;
    }

    @Override
    public int getDomainSize() {
        return this.isInstantiated() ? 1 : 2;
    }

    @Override
    public int getRange() {
        return this.getDomainSize();
    }

    @Override
    public int nextValue(int v) {
        if (this.isInstantiated()) {
            int val = this.getLB();
            return val > v ? val : Integer.MAX_VALUE;
        }
        if (v < 0) {
            return 0;
        }
        if (v == 0) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.isInstantiated()) {
            lb = ub = this.getLB();
        }
        if (lb - 1 <= v && v <= ub) {
            return ub + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.getUB()) {
            return this.getUB();
        }
        if (v > this.getLB()) {
            return this.getLB();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        int lb = 0;
        int ub = 1;
        if (this.isInstantiated()) {
            lb = ub = this.getLB();
        }
        if (lb <= v && v <= ub + 1) {
            return lb - 1;
        }
        return v - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public IEnumDelta getDelta() {
        return this.delta;
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return this.name + " = " + this.getLB();
        }
        return this.name + " = [0,1]";
    }

    @Override
    public void createDelta() {
        if (!this.reactOnRemoval) {
            this.delta = new OneValueDelta(this.model.getEnvironment());
            this.reactOnRemoval = true;
        }
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new OneValueDeltaMonitor(this.delta, propagator);
    }

    @Override
    public int getTypeAndKind() {
        return 0x18 | this.type;
    }

    @Override
    protected EvtScheduler<?> createScheduler() {
        return new BoolEvtScheduler();
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        if (this._javaIterator == null) {
            this._javaIterator = new IntVarValueIterator(this);
        }
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void _setNot(BoolVar neg) {
        this.not = neg;
    }

    @Override
    public BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public boolean hasNot() {
        return this.not != null;
    }

    @Override
    public boolean isLit() {
        return true;
    }

    @Override
    public boolean isNot() {
        return this.isNot;
    }

    @Override
    public void setNot(boolean isNot) {
        this.isNot = isNot;
    }

    @Override
    public int satVar() {
        return MiniSat.var(this.vlit);
    }
}

