/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.events;

import org.chocosolver.solver.variables.events.IEventType;

public enum IntEventType implements IEventType
{
    VOID(0),
    REMOVE(1),
    INCLOW(2),
    DECUPP(4),
    BOUND(6),
    INSTANTIATE(8);

    private final int mask;
    private static final int RIDI;
    private static final int IDI;
    private static final int II;
    private static final int DI;

    private IntEventType(int mask) {
        this.mask = mask;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    @Deprecated
    public static int combine(IntEventType ... evts) {
        int mask = 0;
        for (int i = 0; i < evts.length; ++i) {
            mask |= evts[i].mask;
        }
        return mask;
    }

    public static int all() {
        return RIDI;
    }

    public static int boundAndInst() {
        return IDI;
    }

    public static int lowerBoundAndInst() {
        return II;
    }

    public static int upperBoundAndInst() {
        return DI;
    }

    public static int instantiation() {
        return IntEventType.INSTANTIATE.mask;
    }

    public static boolean isInstantiate(int mask) {
        return (mask & IntEventType.INSTANTIATE.mask) != 0;
    }

    public static boolean isRemove(int mask) {
        return (mask & IntEventType.REMOVE.mask) != 0;
    }

    public static boolean isBound(int mask) {
        return (mask & IntEventType.BOUND.mask) != 0;
    }

    public static boolean isInclow(int mask) {
        return (mask & IntEventType.INCLOW.mask) != 0;
    }

    public static boolean isDecupp(int mask) {
        return (mask & IntEventType.DECUPP.mask) != 0;
    }

    static {
        RIDI = IntEventType.combine(REMOVE, BOUND, INSTANTIATE);
        IDI = IntEventType.combine(BOUND, INSTANTIATE);
        II = IntEventType.combine(INCLOW, INSTANTIATE);
        DI = IntEventType.combine(DECUPP, INSTANTIATE);
    }
}

