/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.choco;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.dynamic.SetDifference;
import org.restopt.choco.LandscapeIndicesUtils;
import org.restopt.choco.SmallestEnclosingCircle;

public class PropSmallestEnclosingCircleSpatialGraph
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final double[][] coordinates;
    private final RealVar radius;
    private final RealVar centerX;
    private final RealVar centerY;
    private ISet envMinusKer;
    private final SmallestEnclosingCircle minidiskLB;
    private final boolean ignoreLB;

    public PropSmallestEnclosingCircleSpatialGraph(UndirectedGraphVar g, double[][] coordinates, RealVar radius, RealVar centerX, RealVar centerY) {
        this(g, coordinates, radius, centerX, centerY, true);
    }

    public PropSmallestEnclosingCircleSpatialGraph(UndirectedGraphVar g, double[][] coordinates, RealVar radius, RealVar centerX, RealVar centerY, boolean ignoreLB) {
        super(new Variable[]{g, radius, centerX, centerY}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = g;
        this.coordinates = coordinates;
        this.radius = radius;
        this.centerX = centerX;
        this.centerY = centerY;
        this.ignoreLB = ignoreLB;
        this.minidiskLB = new SmallestEnclosingCircle(this.getKernelPoints().toArray(), coordinates);
        this.envMinusKer = new SetDifference(this.getModel(), g.getPotentialNodes(), g.getMandatoryNodes(), SetType.BIPARTITESET, 0);
    }

    private ISet getKernelPoints() {
        return this.g.getMandatoryNodes();
    }

    private ISet getEnvelopePoints() {
        return this.g.getPotentialNodes();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        ISet ker = this.getKernelPoints();
        ISet env = this.getEnvelopePoints();
        if (env.size() == 0) {
            if (this.radius.getLB() > 0.0) {
                this.fails();
            }
            return;
        }
        if (ker.size() == env.size()) {
            this.minidiskLB.init(ker.toArray());
            double x = this.minidiskLB.centerX;
            double y = this.minidiskLB.centerY;
            double r = this.minidiskLB.radius;
            if (x > this.centerX.getUB() + this.centerX.getPrecision() || x < this.centerX.getLB() - this.centerX.getPrecision() || y > this.centerY.getUB() + this.centerY.getPrecision() || y < this.centerY.getLB() - this.centerY.getPrecision() || r > this.radius.getUB() + this.radius.getPrecision() || r < this.radius.getLB() - this.radius.getPrecision()) {
                this.fails();
            }
            this.radius.updateBounds(r, r, this);
            this.centerX.updateBounds(x, x, this);
            this.centerY.updateBounds(y, y, this);
            return;
        }
        if (ker.size() > 0) {
            this.minidiskLB.init(ker.toArray());
            double[] cKer = this.minidiskLB.getCenter();
            double rKer = this.minidiskLB.radius;
            if (rKer > this.radius.getUB() + this.radius.getPrecision()) {
                this.fails();
            }
            if (!this.ignoreLB) {
                int[] envArray = env.toArray();
                SmallestEnclosingCircle minidiskEnv = new SmallestEnclosingCircle(envArray, this.coordinates);
                double rEnv = minidiskEnv.radius;
                if (rEnv < this.radius.getLB() - this.radius.getPrecision()) {
                    this.fails();
                }
            }
            ISet remove = SetFactory.makeRangeSet();
            ISetIterator iSetIterator = this.envMinusKer.iterator();
            while (iSetIterator.hasNext()) {
                double[] b_disk;
                int i = (Integer)iSetIterator.next();
                double d = LandscapeIndicesUtils.distance(cKer, this.coordinates[i]);
                if (!(d > this.radius.getUB() + this.radius.getPrecision())) continue;
                if (d > rKer + 2.0 * (this.radius.getUB() + this.radius.getPrecision())) {
                    remove.add(i);
                    continue;
                }
                if (ker.size() <= 1 || !((b_disk = this.minidiskLB.addPoint(this.coordinates[i]))[2] > this.radius.getUB() + this.radius.getPrecision()) && !(b_disk[2] < this.radius.getLB() - this.radius.getPrecision())) continue;
                remove.add(i);
            }
            iSetIterator = remove.iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.g.removeNode(i, this);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        ISet ker = this.getKernelPoints();
        ISet env = this.getEnvelopePoints();
        if (env.size() == 0) {
            if (this.radius.getLB() > 0.0) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        if (ker.size() == env.size()) {
            this.minidiskLB.init(ker.toArray());
            double x = this.minidiskLB.centerX;
            double y = this.minidiskLB.centerY;
            double r = this.minidiskLB.radius;
            if (x > this.centerX.getUB() + this.centerX.getPrecision() || x < this.centerX.getLB() - this.centerX.getPrecision() || y > this.centerY.getUB() + this.centerY.getPrecision() || y < this.centerY.getLB() - this.centerY.getPrecision() || r > this.radius.getUB() + this.radius.getPrecision() || r < this.radius.getLB() - this.radius.getPrecision()) {
                return ESat.TRUE;
            }
            return ESat.TRUE;
        }
        this.minidiskLB.init(ker.toArray());
        SmallestEnclosingCircle minidisk_UB = new SmallestEnclosingCircle(env.toArray(), this.coordinates);
        if (minidisk_UB.pointsArray.length > 0) {
            double x_ub = minidisk_UB.centerX;
            double y_ub = minidisk_UB.centerY;
            double r_ub = minidisk_UB.radius;
            if (r_ub < this.radius.getLB() - this.radius.getPrecision() || x_ub < this.centerX.getLB() - this.centerX.getPrecision() || y_ub < this.centerY.getLB() - this.centerY.getPrecision()) {
                return ESat.FALSE;
            }
            if (this.minidiskLB.pointsArray.length > 0) {
                double x_lb = this.minidiskLB.centerX;
                double y_lb = this.minidiskLB.centerY;
                double r_lb = this.minidiskLB.radius;
                if (r_lb > this.radius.getUB() + this.radius.getPrecision() || x_lb > this.centerX.getUB() + this.centerX.getPrecision() || y_lb > this.centerY.getUB() + this.centerY.getPrecision()) {
                    return ESat.FALSE;
                }
                return ESat.TRUE;
            }
        }
        return ESat.UNDEFINED;
    }
}

