/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule.extend;

import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.HashMap;
import java.util.logging.Logger;

public class AttributeValueAnnotation {
    private final AttributeValue value;
    private final ValueOrigin origin;
    HashMap<Consequent, RuleQuality> qualityByConsequent = new HashMap();
    private static final Logger LOG = Logger.getLogger(AttributeValueAnnotation.class.getName());

    public AttributeValueAnnotation(AttributeValue value, ValueOrigin origin) {
        this.value = value;
        this.origin = origin;
    }

    public void add(Consequent cons, RuleQuality quality) {
        this.qualityByConsequent.put(cons, quality);
    }

    public AttributeValue getValue() {
        return this.value;
    }

    public ValueOrigin getOrigin() {
        return this.origin;
    }

    public HashMap<Consequent, RuleQuality> getDistribution() {
        return this.qualityByConsequent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value:'").append(this.value).append("' origin:").append((Object)this.origin).append("\n");
        this.qualityByConsequent.forEach((consequent, quality) -> sb.append("=> ").append(consequent).append(" | ").append(quality).append("\n"));
        return sb.toString();
    }
}

