## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  eval = FALSE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
#  library(mlexperiments)

## -----------------------------------------------------------------------------
#  library(mlbench)
#  data("DNA")
#  dataset <- DNA |>
#    data.table::as.data.table() |>
#    na.omit()
#  
#  feature_cols <- colnames(dataset)[1:180]
#  target_col <- "Class"

## -----------------------------------------------------------------------------
#  seed <- 123
#  if (isTRUE(as.logical(Sys.getenv("_R_CHECK_LIMIT_CORES_")))) {
#    # on cran
#    ncores <- 2L
#  } else {
#    ncores <- ifelse(
#      test = parallel::detectCores() > 4,
#      yes = 4L,
#      no = ifelse(
#        test = parallel::detectCores() < 2L,
#        yes = 1L,
#        no = parallel::detectCores()
#      )
#    )
#  }
#  options("mlexperiments.bayesian.max_init" = 10L)

## -----------------------------------------------------------------------------
#  data_split <- splitTools::partition(
#    y = dataset[, get(target_col)],
#    p = c(train = 0.7, test = 0.3),
#    type = "stratified",
#    seed = seed
#  )
#  
#  train_x <- model.matrix(
#    ~ -1 + .,
#    dataset[data_split$train, .SD, .SDcols = feature_cols]
#  )
#  train_y <- dataset[data_split$train, get(target_col)]
#  
#  
#  test_x <- model.matrix(
#    ~ -1 + .,
#    dataset[data_split$test, .SD, .SDcols = feature_cols]
#  )
#  test_y <- dataset[data_split$test, get(target_col)]

## -----------------------------------------------------------------------------
#  fold_list <- splitTools::create_folds(
#    y = train_y,
#    k = 3,
#    type = "stratified",
#    seed = seed
#  )

## -----------------------------------------------------------------------------
#  # required learner arguments, not optimized
#  learner_args <- list(method = "class")
#  
#  # set arguments for predict function and performance metric,
#  # required for mlexperiments::MLCrossValidation and
#  # mlexperiments::MLNestedCV
#  predict_args <- list(type = "class")
#  performance_metric <- metric("bacc")
#  performance_metric_args <- NULL
#  return_models <- FALSE
#  
#  # required for grid search and initialization of bayesian optimization
#  parameter_grid <- expand.grid(
#    minsplit = seq(2L, 82L, 10L),
#    cp = seq(0.01, 0.1, 0.01),
#    maxdepth = seq(2L, 30L, 5L)
#  )
#  # reduce to a maximum of 10 rows
#  if (nrow(parameter_grid) > 10) {
#    set.seed(123)
#    sample_rows <- sample(seq_len(nrow(parameter_grid)), 10, FALSE)
#    parameter_grid <- kdry::mlh_subset(parameter_grid, sample_rows)
#  }
#  
#  # required for bayesian optimization
#  parameter_bounds <- list(
#    minsplit = c(2L, 100L),
#    cp = c(0.01, 0.1),
#    maxdepth = c(2L, 30L)
#  )
#  optim_args <- list(
#    iters.n = ncores,
#    kappa = 3.5,
#    acq = "ucb"
#  )

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = LearnerRpart$new(),
#    strategy = "grid",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$learner_args <- learner_args
#  tuner$split_type <- "stratified"
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  tuner_results_grid <- tuner$execute(k = 3)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================>-----------------------------------------------------------------------------] 2/10 ( 20%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================>-------------------------------------------------------------------] 3/10 ( 30%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================>----------------------------------------------------------] 4/10 ( 40%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  
#  head(tuner_results_grid)
#  #>    setting_id metric_optim_mean minsplit   cp maxdepth method
#  #> 1:          1        0.09465558        2 0.07       22  class
#  #> 2:          2        0.09465558       32 0.02       27  class
#  #> 3:          3        0.09465558       72 0.10        7  class
#  #> 4:          4        0.09465558       32 0.09       27  class
#  #> 5:          5        0.09465558       52 0.02       12  class
#  #> 6:          6        0.09465558        2 0.04        7  class

## -----------------------------------------------------------------------------
#  tuner <- mlexperiments::MLTuneParameters$new(
#    learner = LearnerRpart$new(),
#    strategy = "bayesian",
#    ncores = ncores,
#    seed = seed
#  )
#  
#  tuner$parameter_grid <- parameter_grid
#  tuner$parameter_bounds <- parameter_bounds
#  
#  tuner$learner_args <- learner_args
#  tuner$optim_args <- optim_args
#  
#  tuner$split_type <- "stratified"
#  
#  tuner$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  tuner_results_bayesian <- tuner$execute(k = 3)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(tuner_results_bayesian)
#  #>    Epoch setting_id minsplit   cp maxdepth gpUtility acqOptimum inBounds Elapsed       Score metric_optim_mean errorMessage method
#  #> 1:     0          1        2 0.07       22        NA      FALSE     TRUE   2.108 -0.09465558        0.09465558           NA  class
#  #> 2:     0          2       32 0.02       27        NA      FALSE     TRUE   2.122 -0.09465558        0.09465558           NA  class
#  #> 3:     0          3       72 0.10        7        NA      FALSE     TRUE   2.025 -0.09465558        0.09465558           NA  class
#  #> 4:     0          4       32 0.09       27        NA      FALSE     TRUE   2.258 -0.09465558        0.09465558           NA  class
#  #> 5:     0          5       52 0.02       12        NA      FALSE     TRUE   2.030 -0.09465558        0.09465558           NA  class
#  #> 6:     0          6        2 0.04        7        NA      FALSE     TRUE   2.099 -0.09465558        0.09465558           NA  class

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLCrossValidation$new(
#    learner = LearnerRpart$new(),
#    fold_list = fold_list,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$learner_args <- tuner$results$best.setting[-1]
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> CV fold: Fold2
#  #> CV progress [====================================================================>-----------------------------------] 2/3 ( 67%)
#  #>
#  #> CV fold: Fold3
#  #> CV progress [========================================================================================================] 3/3 (100%)
#  #>
#  
#  head(validator_results)
#  #>     fold performance minsplit   cp maxdepth method
#  #> 1: Fold1   0.8950174        2 0.07       22  class
#  #> 2: Fold2   0.8978974        2 0.07       22  class
#  #> 3: Fold3   0.8917513        2 0.07       22  class

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = LearnerRpart$new(),
#    strategy = "grid",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================>-----------------------------------------------------------------------------] 2/10 ( 20%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================>-------------------------------------------------------------------] 3/10 ( 30%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================>----------------------------------------------------------] 4/10 ( 40%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> CV fold: Fold2
#  #> CV progress [====================================================================>-----------------------------------] 2/3 ( 67%)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================>-----------------------------------------------------------------------------] 2/10 ( 20%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================>-------------------------------------------------------------------] 3/10 ( 30%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================>----------------------------------------------------------] 4/10 ( 40%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> CV fold: Fold3
#  #> CV progress [========================================================================================================] 3/3 (100%)
#  #>
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================>-----------------------------------------------------------------------------] 2/10 ( 20%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================>-------------------------------------------------------------------] 3/10 ( 30%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================>----------------------------------------------------------] 4/10 ( 40%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================>------------------------------------------------] 5/10 ( 50%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=========================================================>--------------------------------------] 6/10 ( 60%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [==================================================================>-----------------------------] 7/10 ( 70%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [============================================================================>-------------------] 8/10 ( 80%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [=====================================================================================>----------] 9/10 ( 90%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  #>
#  #> Parameter settings [===============================================================================================] 10/10 (100%)
#  #>  Classification: using 'classification error rate' as optimization metric.
#  
#  head(validator_results)
#  #>     fold performance minsplit   cp maxdepth method
#  #> 1: Fold1   0.8950174        2 0.07       22  class
#  #> 2: Fold2   0.8978974        2 0.07       22  class
#  #> 3: Fold3   0.8917513        2 0.07       22  class

## -----------------------------------------------------------------------------
#  validator <- mlexperiments::MLNestedCV$new(
#    learner = LearnerRpart$new(),
#    strategy = "bayesian",
#    fold_list = fold_list,
#    k_tuning = 3L,
#    ncores = ncores,
#    seed = seed
#  )
#  
#  validator$parameter_grid <- parameter_grid
#  validator$learner_args <- learner_args
#  validator$split_type <- "stratified"
#  
#  
#  validator$parameter_bounds <- parameter_bounds
#  validator$optim_args <- optim_args
#  
#  validator$predict_args <- predict_args
#  validator$performance_metric <- performance_metric
#  validator$performance_metric_args <- performance_metric_args
#  validator$return_models <- return_models
#  
#  validator$set_data(
#    x = train_x,
#    y = train_y
#  )
#  
#  validator_results <- validator$execute()
#  #>
#  #> CV fold: Fold1
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold2
#  #> CV progress [====================================================================>-----------------------------------] 2/3 ( 67%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  #>
#  #> CV fold: Fold3
#  #> CV progress [========================================================================================================] 3/3 (100%)
#  #>
#  #> Registering parallel backend using 4 cores.
#  
#  head(validator_results)
#  #>     fold performance minsplit   cp maxdepth method
#  #> 1: Fold1   0.8950174        2 0.07       22  class
#  #> 2: Fold2   0.8978974        2 0.07       22  class
#  #> 3: Fold3   0.8917513        2 0.07       22  class

