/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Introspection {
    private Introspection() {
    }

    public static Method[] getMethods(Class<?> clazz) {
        List<Method> list = Introspection.internalGetMethods(clazz);
        return list.toArray(new Method[list.size()]);
    }

    private static List<Method> internalGetMethods(Class<?> clazz) {
        Class<?> clazz2;
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            arrayList.add(methodArray[i]);
        }
        List<Method> object2 = new ArrayList<Method>();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            object2.addAll(Introspection.internalGetMethods(classArray[i]));
        }
        if (!clazz.isInterface() && (clazz2 = clazz.getSuperclass()) != null) {
            List<Method> object3 = Introspection.internalGetMethods(clazz2);
            for (Method method : object3) {
                if (method == null || Modifier.isAbstract(method.getModifiers())) continue;
                Introspection.removeByNameAndSignature(object2, method);
            }
            object3.addAll(object2);
            object2 = object3;
        }
        for (Method method : arrayList) {
            Introspection.removeByNameAndSignature(object2, method);
        }
        for (Method method : object2) {
            if (method == null || arrayList.contains(method)) continue;
            arrayList.add(method);
        }
        return arrayList;
    }

    private static void removeByNameAndSignature(List<Method> list, Method method) {
        ListIterator<Method> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Method method2 = listIterator.next();
            if (method2 == null || !method2.getName().equals(method.getName()) || method2.getReturnType() != method.getReturnType() || !Introspection.sameSignature(method2, method)) continue;
            listIterator.set(null);
        }
    }

    public static boolean sameSignature(Method method, Method method2) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    public static Field[] getFields(Class<?> clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Introspection.processFields(clazz, arrayList);
        HashSet hashSet = new HashSet();
        Introspection.processInterfaceFields(clazz, arrayList, hashSet);
        if (!clazz.isInterface()) {
            for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                Introspection.processFields(clazz2, arrayList);
                Introspection.processInterfaceFields(clazz2, arrayList, hashSet);
            }
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    private static void processFields(Class<?> clazz, List<Field> list) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            list.add(fieldArray[i]);
        }
    }

    private static void processInterfaceFields(Class<?> clazz, List<Field> list, Set<Class<?>> set) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (set.contains(classArray[i])) continue;
            set.add(classArray[i]);
            Introspection.processFields(classArray[i], list);
            Introspection.processInterfaceFields(classArray[i], list, set);
        }
    }

    public static Method getMethod(Class<?> clazz, String string, Class[] classArray) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Object object;
            if (!clazz.isInterface()) {
                try {
                    object = clazz.getSuperclass();
                    if (object != null) {
                        return Introspection.getMethod(object, string, classArray);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
            object = clazz.getInterfaces();
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                try {
                    return Introspection.getMethod(object[i], string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    continue;
                }
            }
            throw new NoSuchMethodException("Cannot find method " + string + " in class " + clazz.getName());
        }
    }

    public static Field getField(Class<?> clazz, String string) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class<?>[] classArray = clazz.getInterfaces();
            for (int i = 0; i < classArray.length; ++i) {
                try {
                    return Introspection.getField(classArray[i], string);
                }
                catch (NoSuchFieldException noSuchFieldException2) {
                    continue;
                }
            }
            if (!clazz.isInterface()) {
                try {
                    Class<?> clazz2 = clazz.getSuperclass();
                    if (clazz2 != null) {
                        return Introspection.getField(clazz2, string);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException3) {
                    // empty catch block
                }
            }
            throw new NoSuchFieldException("Cannot find field " + string + " in " + clazz.getName());
        }
    }

    public static String getFieldName(Object object) {
        Class<?> clazz = object.getClass();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!Modifier.isPublic(fieldArray[i].getModifiers()) || !Modifier.isStatic(fieldArray[i].getModifiers()) || !Modifier.isFinal(fieldArray[i].getModifiers())) continue;
            try {
                if (fieldArray[i].get(null) != object) continue;
                return fieldArray[i].getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T valueOf(Class<T> clazz, String string) {
        try {
            Field field = clazz.getField(string);
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers()) && clazz.isAssignableFrom(field.getType())) {
                return (T)field.get(null);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Invalid field name: " + string);
    }

    public static <T> T valueOfIgnoreCase(Class<T> clazz, String string) {
        Field[] fieldArray = clazz.getFields();
        Object object = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!field.getName().equalsIgnoreCase(string) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !clazz.isAssignableFrom(field.getType())) continue;
            try {
                Object object2 = field.get(null);
                if (object != null && object2 != null) {
                    throw new IllegalArgumentException("Found more than one field with the same name in class " + clazz.getName() + " if case is ignored");
                }
                object = object2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (object == null) {
            throw new IllegalArgumentException("Invalid field name: " + string);
        }
        return (T)object;
    }
}

