/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.RadicalInverse;

public class HammersleyPointSet
extends PointSet {
    private int[] base;
    private int[][] permutation;
    private boolean permuted;

    public HammersleyPointSet(int n, int n2) {
        if (n < 0 || n2 < 1) {
            throw new IllegalArgumentException("Hammersley point sets must have positive dimension and n >= 0");
        }
        this.numPoints = n;
        this.dim = n2;
        if (n2 > 1) {
            this.base = RadicalInverse.getPrimes(n2 - 1);
        }
    }

    public void addFaurePermutations() {
        if (this.dim > 1) {
            this.permutation = new int[this.dim][];
            for (int i = 0; i < this.dim - 1; ++i) {
                this.permutation[i] = new int[this.base[i]];
                RadicalInverse.getFaurePermutation(this.base[i], this.permutation[i]);
            }
        }
        this.permuted = true;
    }

    public void ErasePermutations() {
        this.permuted = false;
        this.permutation = null;
    }

    public double getCoordinate(int n, int n2) {
        if (n2 == 0) {
            return (double)n / (double)this.numPoints;
        }
        if (this.permuted) {
            return RadicalInverse.permutedRadicalInverse(this.base[n2 - 1], this.permutation[n2 - 1], n);
        }
        return RadicalInverse.radicalInverse(this.base[n2 - 1], n);
    }
}

