/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.IntMatrix2DProcedure;
import cern.colt.matrix.tint.algo.IntFormatter;
import cern.colt.matrix.tint.algo.IntProperty;
import cern.colt.matrix.tint.algo.IntSorting;
import cern.jet.math.tint.IntFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class IntMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected IntMatrix3D() {
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix3D.this.getQuick(n4, 0, 0));
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < IntMatrix3D.this.columns; ++k) {
                                    n = intIntFunction.apply(n, intFunction.apply(IntMatrix3D.this.getQuick(i, j, k)));
                                }
                                n2 = 0;
                            }
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intFunction.apply(this.getQuick(0, 0, 0));
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        n = intIntFunction.apply(n, intFunction.apply(this.getQuick(i, j, k)));
                    }
                    n6 = 0;
                }
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, final IntProcedure intProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = IntMatrix3D.this.getQuick(n4, 0, 0);
                        int n2 = 0;
                        if (intProcedure.apply(n)) {
                            n2 = intIntFunction.apply(n2, intFunction.apply(n));
                        }
                        int n3 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = n3; k < IntMatrix3D.this.columns; ++k) {
                                    n = IntMatrix3D.this.getQuick(i, j, k);
                                    if (intProcedure.apply(n)) {
                                        n2 = intIntFunction.apply(n2, intFunction.apply(n));
                                    }
                                    n3 = 0;
                                }
                            }
                        }
                        return n2;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            int n6 = this.getQuick(0, 0, 0);
            if (intProcedure.apply(n6)) {
                n = intIntFunction.apply(n, intFunction.apply(n6));
            }
            int n7 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n7; k < this.columns; ++k) {
                        n6 = this.getQuick(i, j, k);
                        if (intProcedure.apply(n6)) {
                            n = intIntFunction.apply(n, intFunction.apply(n6));
                        }
                        n7 = 0;
                    }
                }
            }
        }
        return n;
    }

    public int aggregate(final IntIntFunction intIntFunction, final IntFunction intFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        if (intArrayList.size() == 0 || intArrayList2.size() == 0 || intArrayList3.size() == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n2 = 0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n3 = Math.min(n3, n);
            Future[] futureArray = new Future[n3];
            int n4 = n / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intFunction.apply(IntMatrix3D.this.getQuick(nArray[n5], nArray2[n5], nArray3[n5]));
                        for (int i = n5 + 1; i < n6; ++i) {
                            int n2 = IntMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                            n = intIntFunction.apply(n, intFunction.apply(n2));
                        }
                        return n;
                    }
                });
            }
            n2 = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n2 = intFunction.apply(this.getQuick(nArray[0], nArray2[0], nArray3[0]));
            for (int i = 1; i < n; ++i) {
                int n7 = this.getQuick(nArray[i], nArray2[i], nArray3[i]);
                n2 = intIntFunction.apply(n2, intFunction.apply(n7));
            }
        }
        return n2;
    }

    public int aggregate(final IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction, final IntIntFunction intIntFunction2) {
        this.checkShape(intMatrix3D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = intIntFunction2.apply(IntMatrix3D.this.getQuick(n4, 0, 0), intMatrix3D.getQuick(n4, 0, 0));
                        int n2 = 1;
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = n2; k < IntMatrix3D.this.columns; ++k) {
                                    n = intIntFunction.apply(n, intIntFunction2.apply(IntMatrix3D.this.getQuick(i, j, k), intMatrix3D.getQuick(i, j, k)));
                                }
                                n2 = 0;
                            }
                        }
                        return n;
                    }
                });
            }
            n = ConcurrencyUtils.waitForCompletion(futureArray, intIntFunction);
        } else {
            n = intIntFunction2.apply(this.getQuick(0, 0, 0), intMatrix3D.getQuick(0, 0, 0));
            int n6 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n6; k < this.columns; ++k) {
                        n = intIntFunction.apply(n, intIntFunction2.apply(this.getQuick(i, j, k), intMatrix3D.getQuick(i, j, k)));
                    }
                    n6 = 0;
                }
            }
        }
        return n;
    }

    public IntMatrix3D assign(final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, intFunction.apply(IntMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, intFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, n);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, n);
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[] nArray) {
        if (nArray.length != this.slices * this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + nArray.length + "slices()*rows()*columns()=" + this.slices() * this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * IntMatrix3D.this.rows * IntMatrix3D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, nArray[n++]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, nArray[n5++]);
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final int[][][] nArray) {
        if (nArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + nArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int[][] nArray3 = nArray[i];
                            if (nArray3.length != IntMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray3.length + "rows()=" + IntMatrix3D.this.rows());
                            }
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                int[] nArray2 = nArray3[j];
                                if (nArray2.length != IntMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray2.length + "columns()=" + IntMatrix3D.this.columns());
                                }
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, nArray2[k]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int[][] nArray2 = nArray[i];
                if (nArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + nArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    int[] nArray3 = nArray2[j];
                    if (nArray3.length != this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + nArray3.length + "columns()=" + this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, nArray3[k]);
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure intProcedure, final IntFunction intFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    int n = IntMatrix3D.this.getQuick(i, j, k);
                                    if (!intProcedure.apply(n)) continue;
                                    IntMatrix3D.this.setQuick(i, j, k, intFunction.apply(n));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        int n5 = this.getQuick(i, j, k);
                        if (!intProcedure.apply(n5)) continue;
                        this.setQuick(i, j, k, intFunction.apply(n5));
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntProcedure intProcedure, final int n) {
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    int n2 = IntMatrix3D.this.getQuick(i, j, k);
                                    if (!intProcedure.apply(n2)) continue;
                                    IntMatrix3D.this.setQuick(i, j, k, n);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        int n6 = this.getQuick(i, j, k);
                        if (!intProcedure.apply(n6)) continue;
                        this.setQuick(i, j, k, n);
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(IntMatrix3D intMatrix3D) {
        if (intMatrix3D == this) {
            return this;
        }
        this.checkShape(intMatrix3D);
        final IntMatrix3D intMatrix3D2 = this.haveSharedCells(intMatrix3D) ? intMatrix3D.copy() : intMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, intMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, intMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction) {
        this.checkShape(intMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    IntMatrix3D.this.setQuick(i, j, k, intIntFunction.apply(IntMatrix3D.this.getQuick(i, j, k), intMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, intIntFunction.apply(this.getQuick(i, j, k), intMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public IntMatrix3D assign(final IntMatrix3D intMatrix3D, final IntIntFunction intIntFunction, IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3) {
        this.checkShape(intMatrix3D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final int[] nArray3 = intArrayList3.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            IntMatrix3D.this.setQuick(nArray[i], nArray2[i], nArray3[i], intIntFunction.apply(IntMatrix3D.this.getQuick(nArray[i], nArray2[i], nArray3[i]), intMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], nArray3[i], intIntFunction.apply(this.getQuick(nArray[i], nArray2[i], nArray3[i]), intMatrix3D.getQuick(nArray[i], nArray2[i], nArray3[i])));
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    if (IntMatrix3D.this.getQuick(i, j, k) == 0) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        if (this.getQuick(i, j, k) == 0) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public IntMatrix3D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(int n) {
        return IntProperty.DEFAULT.equals(this, n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof IntMatrix3D)) {
            return false;
        }
        return IntProperty.DEFAULT.equals(this, (IntMatrix3D)object);
    }

    public int get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    protected IntMatrix3D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    int n = this.getQuick(i, j, k);
                    if (n >= 0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    intArrayList4.add(n);
                }
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    int n = this.getQuick(i, j, k);
                    if (n == 0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    intArrayList4.add(n);
                }
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, IntArrayList intArrayList4) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        intArrayList4.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    int n = this.getQuick(i, j, k);
                    if (n <= 0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    intArrayList4.add(n);
                }
            }
        }
    }

    public abstract int getQuick(int var1, int var2, int var3);

    protected boolean haveSharedCells(IntMatrix3D intMatrix3D) {
        if (intMatrix3D == null) {
            return false;
        }
        if (this == intMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(intMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(IntMatrix3D intMatrix3D) {
        return false;
    }

    public IntMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract IntMatrix3D like(int var1, int var2, int var3);

    public abstract IntMatrix2D like2D(int var1, int var2);

    protected abstract IntMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    public int[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n8;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = IntMatrix3D.this.getQuick(n, 0, 0);
                        int n5 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = n5; k < IntMatrix3D.this.columns; ++k) {
                                    int n6 = IntMatrix3D.this.getQuick(i, j, k);
                                    if (n4 >= n6) continue;
                                    n4 = n6;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n5 = 0;
                            }
                        }
                        return new int[]{n4, n, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                n3 = nArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 >= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                    n3 = nArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.getQuick(0, 0, 0);
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = this.getQuick(i, j, k);
                        if (n4 >= n11) continue;
                        n4 = n11;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new int[]{n4, n, n2, n3};
    }

    public int[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n6;
            n5 = Math.min(n5, this.slices);
            Future[] futureArray = new Future[n5];
            int[][] nArray = new int[n5][2];
            int n7 = this.slices / n5;
            for (n6 = 0; n6 < n5; ++n6) {
                final int n8 = n6 * n7;
                final int n9 = n6 == n5 - 1 ? this.slices : n8 + n7;
                futureArray[n6] = ConcurrencyUtils.submit(new Callable<int[]>(){

                    @Override
                    public int[] call() throws Exception {
                        int n = n8;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = IntMatrix3D.this.getQuick(n, 0, 0);
                        int n5 = 1;
                        for (int i = n8; i < n9; ++i) {
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                for (int k = n5; k < IntMatrix3D.this.columns; ++k) {
                                    int n6 = IntMatrix3D.this.getQuick(i, j, k);
                                    if (n4 <= n6) continue;
                                    n4 = n6;
                                    n = i;
                                    n2 = j;
                                    n3 = k;
                                }
                                n5 = 0;
                            }
                        }
                        return new int[]{n4, n, n2, n3};
                    }
                });
            }
            try {
                for (n6 = 0; n6 < n5; ++n6) {
                    nArray[n6] = (int[])futureArray[n6].get();
                }
                n4 = nArray[0][0];
                n = nArray[0][1];
                n2 = nArray[0][2];
                n3 = nArray[0][3];
                for (n6 = 1; n6 < n5; ++n6) {
                    if (n4 <= nArray[n6][0]) continue;
                    n4 = nArray[n6][0];
                    n = nArray[n6][1];
                    n2 = nArray[n6][2];
                    n3 = nArray[n6][3];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            n4 = this.getQuick(0, 0, 0);
            int n10 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n10; k < this.columns; ++k) {
                        int n11 = this.getQuick(i, j, k);
                        if (n4 <= n11) continue;
                        n4 = n11;
                        n = i;
                        n2 = j;
                        n3 = k;
                    }
                    n10 = 0;
                }
            }
        }
        return new int[]{n4, n, n2, n3};
    }

    public void set(int n, int n2, int n3, int n4) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, n4);
    }

    public abstract void setQuick(int var1, int var2, int var3, int var4);

    public int[][][] toArray() {
        final int[][][] nArray = new int[this.slices][this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            int[][] nArray3 = nArray[i];
                            for (int j = 0; j < IntMatrix3D.this.rows; ++j) {
                                int[] nArray2 = nArray3[j];
                                for (int k = 0; k < IntMatrix3D.this.columns; ++k) {
                                    nArray2[k] = IntMatrix3D.this.getQuick(i, j, k);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                int[][] nArray2 = nArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    int[] nArray3 = nArray2[j];
                    for (int k = 0; k < this.columns; ++k) {
                        nArray3[k] = this.getQuick(i, j, k);
                    }
                }
            }
        }
        return nArray;
    }

    public String toString() {
        return new IntFormatter().toString(this);
    }

    public abstract IntMatrix1D vectorize();

    protected IntMatrix3D view() {
        return (IntMatrix3D)this.clone();
    }

    public IntMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public IntMatrix3D viewColumnFlip() {
        return (IntMatrix3D)this.view().vColumnFlip();
    }

    public IntMatrix3D viewDice(int n, int n2, int n3) {
        return (IntMatrix3D)this.view().vDice(n, n2, n3);
    }

    public IntMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (IntMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public IntMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public IntMatrix3D viewRowFlip() {
        return (IntMatrix3D)this.view().vRowFlip();
    }

    public IntMatrix3D viewSelection(IntMatrix2DProcedure intMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!intMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public IntMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            for (n2 = 0; n2 < this.slices; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    protected abstract IntMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public IntMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public IntMatrix3D viewSliceFlip() {
        return (IntMatrix3D)this.view().vSliceFlip();
    }

    public IntMatrix3D viewSorted(int n, int n2) {
        return IntSorting.mergeSort.sort(this, n, n2);
    }

    public IntMatrix3D viewStrides(int n, int n2, int n3) {
        return (IntMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public int zSum() {
        if (this.size() == 0L) {
            return 0;
        }
        return this.aggregate(IntFunctions.plus, IntFunctions.identity);
    }
}

