/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;

class DelegateFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix2D content;
    protected int row;

    public DelegateFComplexMatrix1D(FComplexMatrix2D fComplexMatrix2D, int n) {
        if (n < 0 || n >= fComplexMatrix2D.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(fComplexMatrix2D.columns());
        this.row = n;
        this.content = fComplexMatrix2D;
    }

    public synchronized float[] getQuick(int n) {
        return this.content.getQuick(this.row, n);
    }

    public FComplexMatrix1D like(int n) {
        return this.content.like1D(n);
    }

    public FComplexMatrix2D like2D(int n, int n2) {
        return this.content.like(n, n2);
    }

    public synchronized void setQuick(int n, float[] fArray) {
        this.content.setQuick(this.row, n, fArray);
    }

    public synchronized void setQuick(int n, float f, float f2) {
        this.content.setQuick(this.row, n, f, f2);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FloatMatrix1D getImaginaryPart() {
        return this.content.viewRow(this.row).getImaginaryPart();
    }

    public FloatMatrix1D getRealPart() {
        return this.content.viewRow(this.row).getRealPart();
    }
}

