#!/usr/bin/env perl
use Test::More tests => 3;
use strict;
use warnings;
no strict 'refs';

use lib '../lib';

our $module;
BEGIN {
    our $module = 'Crypt::MagicSignatures::Key';
    use_ok($module, qw/b64url_encode b64url_decode/);   # 1
};

# https://github.com/eschnou/node-ostatus/blob/master/tests/test-salmon.js

my $test_public_key =<<'TEST_PKEY';
RSA.iuv17d7U1uJxgDbCt1nEtaIbKAmV02MWIQLubaW
Dc4juUBmdvbY1ms0EtFhrYLSK1j3kyqysM7vqjj-DYD
bq2NPQpUrq2DFqj7Y2b8PG4-Dj6KUPDmkVRa-ZFo63B
WX6US5Vsi31HHFh_rku1OPdPrHjQhtN8HeFYnNBpd4U
AA0=.AQAB
TEST_PKEY

my $b64_test_msg =<<'TEST_MSG';
PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVR
GLTgiID8-PGVudHJ5IHhtbG5zPSJodHRwOi8vd3d3Ln
czLm9yZy8yMDA1L0F0b20iIHhtbG5zOnRocj0iaHR0c
DovL3B1cmwub3JnL3N5bmRpY2F0aW9uL3RocmVhZC8x
LjAiIHhtbG5zOmFjdGl2aXR5PSJodHRwOi8vYWN0aXZ
pdHlzdHJlYS5tcy9zcGVjLzEuMC8iIHhtbG5zOmdlb3
Jzcz0iaHR0cDovL3d3dy5nZW9yc3Mub3JnL2dlb3Jzc
yIgeG1sbnM6b3N0YXR1cz0iaHR0cDovL29zdGF0dXMu
b3JnL3NjaGVtYS8xLjAiIHhtbG5zOnBvY289Imh0dHA
6Ly9wb3J0YWJsZWNvbnRhY3RzLm5ldC9zcGVjLzEuMC
IgeG1sbnM6bWVkaWE9Imh0dHA6Ly9wdXJsLm9yZy9ze
W5kaWNhdGlvbi9hdG9tbWVkaWEiIHhtbG5zOnN0YXR1
c25ldD0iaHR0cDovL3N0YXR1cy5uZXQvc2NoZW1hL2F
waS8xLyI-CiA8YWN0aXZpdHk6b2JqZWN0LXR5cGU-aH
R0cDovL2FjdGl2aXR5c3RyZWEubXMvc2NoZW1hLzEuM
C9ub3RlPC9hY3Rpdml0eTpvYmplY3QtdHlwZT4KIDxp
ZD5odHRwOi8vaWRlbnRpLmNhL25vdGljZS82NTEzOTc
5MjwvaWQ-CiA8dGl0bGU-dGhpcyBvbmUgaXMgZm9yIE
BjYXBhQGVzY2hlbmF1ZXIuYmUgLSBlbmpveSAhPC90a
XRsZT4KIDxjb250ZW50IHR5cGU9Imh0bWwiPnRoaXMg
b25lIGlzIGZvciBAJmx0O3NwYW4gY2xhc3M9JnF1b3Q
7dmNhcmQmcXVvdDsmZ3Q7Jmx0O2EgaHJlZj0mcXVvdD
todHRwOi8vZXNjaGVuYXVlci5iZS91c2Vycy9jYXBhJ
nF1b3Q7IGNsYXNzPSZxdW90O3VybCZxdW90OyZndDsm
bHQ7c3BhbiBjbGFzcz0mcXVvdDtmbiBuaWNrbmFtZSZ
xdW90OyZndDtjYXBhQGVzY2hlbmF1ZXIuYmUmbHQ7L3
NwYW4mZ3Q7Jmx0Oy9hJmd0OyZsdDsvc3BhbiZndDsgL
SBlbmpveSAhPC9jb250ZW50PgogPGxpbmsgcmVsPSJh
bHRlcm5hdGUiIHR5cGU9InRleHQvaHRtbCIgaHJlZj0
iaHR0cDovL2lkZW50aS5jYS9ub3RpY2UvNjUxMzk3OT
IiLz4KIDxhY3Rpdml0eTp2ZXJiPmh0dHA6Ly9hY3Rpd
ml0eXN0cmVhLm1zL3NjaGVtYS8xLjAvcG9zdDwvYWN0
aXZpdHk6dmVyYj4KIDxwdWJsaXNoZWQ-MjAxMS0wMi0
yMlQyMToyMjo0OSswMDowMDwvcHVibGlzaGVkPgogPH
VwZGF0ZWQ-MjAxMS0wMi0yMlQyMToyMjo0OSswMDowM
DwvdXBkYXRlZD4KIDxhdXRob3I-CiAgPGFjdGl2aXR5
Om9iamVjdC10eXBlPmh0dHA6Ly9hY3Rpdml0eXN0cmV
hLm1zL3NjaGVtYS8xLjAvcGVyc29uPC9hY3Rpdml0eT
pvYmplY3QtdHlwZT4KICA8dXJpPmh0dHA6Ly9pZGVud
GkuY2EvdXNlci8zODUyMTY8L3VyaT4KICA8bmFtZT5z
aG91dHI8L25hbWU-CiAgPGxpbmsgcmVsPSJhbHRlcm5
hdGUiIHR5cGU9InRleHQvaHRtbCIgaHJlZj0iaHR0cD
ovL2lkZW50aS5jYS9zaG91dHIiLz4KICA8bGluayByZ
Ww9ImF2YXRhciIgdHlwZT0iaW1hZ2UvcG5nIiBtZWRp
YTp3aWR0aD0iOTYiIG1lZGlhOmhlaWdodD0iOTYiIGh
yZWY9Imh0dHA6Ly90aGVtZS5pZGVudGkuY2EvMC45Lj
diZXRhMi9pZGVudGljYS9kZWZhdWx0LWF2YXRhci1wc
m9maWxlLnBuZyIvPgogIDxsaW5rIHJlbD0iYXZhdGFy
IiB0eXBlPSJpbWFnZS9wbmciIG1lZGlhOndpZHRoPSI
0OCIgbWVkaWE6aGVpZ2h0PSI0OCIgaHJlZj0iaHR0cD
ovL3RoZW1lLmlkZW50aS5jYS8wLjkuN2JldGEyL2lkZ
W50aWNhL2RlZmF1bHQtYXZhdGFyLXN0cmVhbS5wbmci
Lz4KICA8bGluayByZWw9ImF2YXRhciIgdHlwZT0iaW1
hZ2UvcG5nIiBtZWRpYTp3aWR0aD0iMjQiIG1lZGlhOm
hlaWdodD0iMjQiIGhyZWY9Imh0dHA6Ly90aGVtZS5pZ
GVudGkuY2EvMC45LjdiZXRhMi9pZGVudGljYS9kZWZh
dWx0LWF2YXRhci1taW5pLnBuZyIvPgogIDxwb2NvOnB
yZWZlcnJlZFVzZXJuYW1lPnNob3V0cjwvcG9jbzpwcm
VmZXJyZWRVc2VybmFtZT4KICA8cG9jbzpkaXNwbGF5T
mFtZT5TaG91dHI8L3BvY286ZGlzcGxheU5hbWU-CiAg
PHBvY286dXJscz4KICAgPHBvY286dHlwZT5ob21lcGF
nZTwvcG9jbzp0eXBlPgogICA8cG9jbzp2YWx1ZT5odH
RwOi8vc2hvdXRyLm9yZzwvcG9jbzp2YWx1ZT4KICAgP
HBvY286cHJpbWFyeT50cnVlPC9wb2NvOnByaW1hcnk-
CjwvcG9jbzp1cmxzPgo8L2F1dGhvcj4KIDwhLS1EZXB
yZWNhdGlvbiB3YXJuaW5nOiBhY3Rpdml0eTphY3Rvci
BpcyBwcmVzZW50IG9ubHkgZm9yIGJhY2t3YXJkIGNvb
XBhdGliaWxpdHkuIEl0IHdpbGwgYmUgcmVtb3ZlZCBp
biB0aGUgbmV4dCB2ZXJzaW9uIG9mIFN0YXR1c05ldC4
tLT4KIDxhY3Rpdml0eTphY3Rvcj4KICA8YWN0aXZpdH
k6b2JqZWN0LXR5cGU-aHR0cDovL2FjdGl2aXR5c3RyZ
WEubXMvc2NoZW1hLzEuMC9wZXJzb248L2FjdGl2aXR5
Om9iamVjdC10eXBlPgogIDxpZD5odHRwOi8vaWRlbnR
pLmNhL3VzZXIvMzg1MjE2PC9pZD4KICA8dGl0bGU-U2
hvdXRyPC90aXRsZT4KICA8bGluayByZWw9ImFsdGVyb
mF0ZSIgdHlwZT0idGV4dC9odG1sIiBocmVmPSJodHRw
Oi8vaWRlbnRpLmNhL3Nob3V0ciIvPgogIDxsaW5rIHJ
lbD0iYXZhdGFyIiB0eXBlPSJpbWFnZS9wbmciIG1lZG
lhOndpZHRoPSI5NiIgbWVkaWE6aGVpZ2h0PSI5NiIga
HJlZj0iaHR0cDovL3RoZW1lLmlkZW50aS5jYS8wLjku
N2JldGEyL2lkZW50aWNhL2RlZmF1bHQtYXZhdGFyLXB
yb2ZpbGUucG5nIi8-CiAgPGxpbmsgcmVsPSJhdmF0YX
IiIHR5cGU9ImltYWdlL3BuZyIgbWVkaWE6d2lkdGg9I
jQ4IiBtZWRpYTpoZWlnaHQ9IjQ4IiBocmVmPSJodHRw
Oi8vdGhlbWUuaWRlbnRpLmNhLzAuOS43YmV0YTIvaWR
lbnRpY2EvZGVmYXVsdC1hdmF0YXItc3RyZWFtLnBuZy
IvPgogIDxsaW5rIHJlbD0iYXZhdGFyIiB0eXBlPSJpb
WFnZS9wbmciIG1lZGlhOndpZHRoPSIyNCIgbWVkaWE6
aGVpZ2h0PSIyNCIgaHJlZj0iaHR0cDovL3RoZW1lLml
kZW50aS5jYS8wLjkuN2JldGEyL2lkZW50aWNhL2RlZm
F1bHQtYXZhdGFyLW1pbmkucG5nIi8-CiAgPHBvY286c
HJlZmVycmVkVXNlcm5hbWU-c2hvdXRyPC9wb2NvOnBy
ZWZlcnJlZFVzZXJuYW1lPgogIDxwb2NvOmRpc3BsYXl
OYW1lPlNob3V0cjwvcG9jbzpkaXNwbGF5TmFtZT4KIC
A8cG9jbzp1cmxzPgogICA8cG9jbzp0eXBlPmhvbWVwY
WdlPC9wb2NvOnR5cGU-CiAgIDxwb2NvOnZhbHVlPmh0
dHA6Ly9zaG91dHIub3JnPC9wb2NvOnZhbHVlPgogICA
8cG9jbzpwcmltYXJ5PnRydWU8L3BvY286cHJpbWFyeT
4KPC9wb2NvOnVybHM-CjwvYWN0aXZpdHk6YWN0b3I-C
iA8bGluayByZWw9Im9zdGF0dXM6Y29udmVyc2F0aW9u
IiBocmVmPSJodHRwOi8vaWRlbnRpLmNhL2NvbnZlcnN
hdGlvbi82NDM4Mjk1NSIvPgogPGxpbmsgcmVsPSJvc3
RhdHVzOmF0dGVudGlvbiIgaHJlZj0iaHR0cDovL2VzY
2hlbmF1ZXIuYmUvdXNlcnMvY2FwYSIvPgogPGxpbmsg
cmVsPSJtZW50aW9uZWQiIGhyZWY9Imh0dHA6Ly9lc2N
oZW5hdWVyLmJlL3VzZXJzL2NhcGEiLz4KIDxnZW9yc3
M6cG9pbnQ-NTAuNTY2NjcgNS41ODMzMzwvZ2VvcnNzO
nBvaW50PgogPHNvdXJjZT4KICA8aWQ-aHR0cDovL2Vz
Y2hlbmF1ZXIuYmUvdXBkYXRlcy9jYXBhLmF0b208L2l
kPgogIDx0aXRsZT5jYXBhPC90aXRsZT4KICA8bGluay
ByZWw9ImFsdGVybmF0ZSIgdHlwZT0idGV4dC9odG1sI
iBocmVmPSJodHRwOi8vZXNjaGVuYXVlci5iZS91c2Vy
cy9jYXBhIi8-CiAgPGxpbmsgcmVsPSJzZWxmIiB0eXB
lPSJhcHBsaWNhdGlvbi9hdG9tK3htbCIgaHJlZj0iaH
R0cDovL2VzY2hlbmF1ZXIuYmUvdXBkYXRlcy9jYXBhL
mF0b20iLz4KICA8aWNvbj5odHRwOi8vdGhlbWUuaWRl
bnRpLmNhLzAuOS43YmV0YTIvaWRlbnRpY2EvZGVmYXV
sdC1hdmF0YXItcHJvZmlsZS5wbmc8L2ljb24-Cjwvc2
91cmNlPgogPGxpbmsgcmVsPSJzZWxmIiB0eXBlPSJhc
HBsaWNhdGlvbi9hdG9tK3htbCIgaHJlZj0iaHR0cDov
L2lkZW50aS5jYS9hcGkvc3RhdHVzZXMvc2hvdy82NTE
zOTc5Mi5hdG9tIi8-CiA8bGluayByZWw9ImVkaXQiIH
R5cGU9ImFwcGxpY2F0aW9uL2F0b20reG1sIiBocmVmP
SJodHRwOi8vaWRlbnRpLmNhL2FwaS9zdGF0dXNlcy9z
aG93LzY1MTM5NzkyLmF0b20iLz4KIDxzdGF0dXNuZXQ
6bm90aWNlX2luZm8gbG9jYWxfaWQ9IjY1MTM5NzkyIi
Bzb3VyY2U9IndlYiI-PC9zdGF0dXNuZXQ6bm90aWNlX
2luZm8-CjwvZW50cnk-Cg==
TEST_MSG

my $test_msg = b64url_decode($b64_test_msg);

# New signature:
my $test_sig =<<'TEST_SIG';
UqKwh0XSOhdSD7U9nVHxB67sCNt8lQzkl5aPELQTfuh
rlBoktbExhhkP4QGFg0WS0FgPnQpG24z5S4XIk2BTjI
8My-VlwRWdeU72NtnLhZjz8EzA1aJTI_Drs71-YICuM
_dLAJgo55pF4nIMkRN9KA-rS-y7oC3cwt01MknR8UQ=
TEST_SIG

my $mkey = Crypt::MagicSignatures::Key->new($test_public_key);

is($mkey->size, 1024, 'Correct key size');

ok($mkey->verify(b64url_encode(b64url_decode($b64_test_msg)),
		 $test_sig), 'Signature okay.');

__END__




