package WebService::Mattermost::V4::API::Resource::Logs;

# ABSTRACT: Wrapped API methods for the logs API endpoints.

use Moo;
use Types::Standard 'Str';

extends 'WebService::Mattermost::V4::API::Resource';

################################################################################

has view_name => (is => 'ro', isa => Str, default => 'Log');

################################################################################

sub get {
    my $self = shift;

    return $self->_get();
}

sub add_message {
    my $self = shift;
    my $args = shift;

    return $self->_post({
        parameters => $args,
        required   => [ qw(level message) ],
        view       => 'NewLogEntry',
    });
}

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Resource::Logs - Wrapped API methods for the logs API endpoints.

=head1 VERSION

version 0.26

=head1 DESCRIPTION

=head2 USAGE

    use WebService::Mattermost;

    my $mm = WebService::Mattermost->new({
        authenticate => 1,
        username     => 'me@somewhere.com',
        password     => 'hunter2',
        base_url     => 'https://my.mattermost.server.com/api/v4/',
    });

    my $resource = $mm->api->logs;

=head2 METHODS

=over 4

=item C<get()>

L<Get logs|https://api.mattermost.com/#tag/system%2Fpaths%2F~1logs%2Fget>

    my $response = $resource->get();

=item C<add_message()>

L<Add log message|https://api.mattermost.com/#tag/system%2Fpaths%2F~1logs%2Fpost>

    my $response = $resource->add_message({
        # Required parameters:
        level   => 'ERROR', # or DEBUG
        message => '...',
    });

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
