/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.media.jai.JaiI18N;

public class IntegerSequence {
    private int min;
    private int max;
    private static final int DEFAULT_CAPACITY = 16;
    private int[] iArray = null;
    private int capacity = 0;
    private int numElts = 0;
    private boolean isSorted = false;
    private int currentIndex = -1;

    public IntegerSequence(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(JaiI18N.getString("IntegerSequence1"));
        }
        this.min = n;
        this.max = n2;
        this.capacity = 16;
        this.iArray = new int[this.capacity];
        this.numElts = 0;
        this.isSorted = true;
    }

    public IntegerSequence() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public void insert(int n) {
        if (n < this.min || n > this.max) {
            return;
        }
        if (this.numElts >= this.capacity) {
            int n2 = 2 * this.capacity;
            int[] nArray = new int[n2];
            System.arraycopy(this.iArray, 0, nArray, 0, this.capacity);
            this.capacity = n2;
            this.iArray = nArray;
        }
        this.isSorted = false;
        this.iArray[this.numElts++] = n;
    }

    public void startEnumeration() {
        if (!this.isSorted) {
            Arrays.sort(this.iArray, 0, this.numElts);
            int n = 1;
            int n2 = 1;
            int n3 = this.iArray[0];
            n = 1;
            while (n < this.numElts) {
                int n4 = this.iArray[n];
                if (n4 != n3) {
                    this.iArray[n2++] = n4;
                    n3 = n4;
                }
                ++n;
            }
            this.numElts = n2;
            this.isSorted = true;
        }
        this.currentIndex = 0;
    }

    public boolean hasMoreElements() {
        return this.currentIndex < this.numElts;
    }

    public int nextElement() {
        if (this.currentIndex < this.numElts) {
            return this.iArray[this.currentIndex++];
        }
        throw new NoSuchElementException(JaiI18N.getString("IntegerSequence0"));
    }

    public int getNumElements() {
        return this.numElts;
    }

    public String toString() {
        String string;
        if (this.numElts == 0) {
            string = "[<empty>]";
        } else {
            string = "[";
            this.startEnumeration();
            int n = 0;
            while (n < this.numElts - 1) {
                string = string + this.iArray[n];
                string = string + ", ";
                ++n;
            }
            string = string + this.iArray[this.numElts - 1];
            string = string + "]";
        }
        return string;
    }
}

