#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::MyMessagesAlertResolutionStatusCode;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. MyMessagesAlertResolutionStatusCode.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::MyMessagesAlertResolutionStatusCode

=head1 DESCRIPTION

MyMessagesAlertResolutionStatusCode - Whether or not an alert was resolved, and how.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Unresolved

The alert has not been resolved. If the alert requires user action, an unresolved status
means that the user did not take action on the alert. If the alert does not require user
action, an unresolved status means that the alert has not been read. Note that an
unresolved alert can not be deleted.



=cut


use constant Unresolved => scalar('Unresolved');


=head2 ResolvedByAutoResolution

The alert was resolved by auto resolution, for example,
by expiring after a certain date.



=cut


use constant ResolvedByAutoResolution => scalar('ResolvedByAutoResolution');


=head2 ResolvedByUser

The alert was resolved by user. If the alert requires user action, resolved status
means that the user took the necessary action on the alert. If the alert does not require user
action, resolved status means that the alert was read by the user.



=cut


use constant ResolvedByUser => scalar('ResolvedByUser');


=head2 CustomCode

=cut


use constant CustomCode => scalar('CustomCode');







1;   
