package Acme::MetaSyntactic::daleks;
use strict;
use warnings;
use Acme::MetaSyntactic::List;
use vars qw(%Remote);

{
    no strict "vars";
    $VERSION = '1.05';
    @ISA = qw(Acme::MetaSyntactic::List);
}

*_tr_nonword = \&Acme::MetaSyntactic::RemoteList::tr_nonword;

sub _uniq { return keys %{ { map { $_ => 1 } @_ } } }

%Remote = (
    source  => "http://maddingue.org/daleks/movies.txt",
    extract => sub {
        return sort _uniq(
            map { $_ = _tr_nonword($_) ; s/^_+|_+$//g ; s/_+/_/g ; $_ }
                grep { !/^\d/ }
                    grep { length }
                        split "\012", shift
        )
    },
);

__PACKAGE__->init();

q!EXTERMINATE!;

=head1 NAME

Acme::MetaSyntactic::daleks - EXTERMINATE! EXTERMINATE! EXTERMINATE!

=head1 VERSION

Version 1.05

=head1 SYNOPSIS

See L<Acme::MetaSyntactic>.

=head1 DESCRIPTION

A list of movies for the Daleks. A collective work of C<#perl>.
See L<http://use.perl.org/~statico/journal/21689>

I've tried to remove all the duplicates and comments I could find, 
but there are probably still a few left. The source file used to
generate this module is located at L<http://maddingue.org/daleks/movies.txt>.
Don't hesitate to send patch to remove duplicate or wrong entries,
or to propose new entries.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Acme::MetaSyntactic::daleks

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-MetaSyntactic-daleks>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Acme-MetaSyntactic-daleks>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Acme-MetaSyntactic-daleks>

=item * Search CPAN

L<http://search.cpan.org/dist/Acme-MetaSyntactic-daleks>

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>

=head1 COPYRIGHT & LICENSE

Copyright 2007 SE<eacute>bastien Aperghis-Tramoni, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

__DATA__
# names
A_Beautiful_Dalek
A_Clockwork_Dalek
A_Connecticut_Dalek_in_King_Arthur_s_Court
A_Connecticut_Yankee_in_King_Arthur_s_Dalek
A_Dalek_at_the_opera
A_Dalek_at_the_Races
A_Dalek_called_Wanda
A_Dalek_for_All_Seasons
A_Dalek_is_Born
A_Dalek_named_Charlie_Brown
A_Dalek_named_desire
A_Dalek_of_their_own
A_Dalek_story
A_Dalek_to_Kill
A_Dalek_too_far
A_Date_with_your_Dalek
A_Day_in_the_Life_of_Ivan_Dalekovich
A_Dirty_Dalek
A_Fistful_of_Daleks
A_Hard_Dalek_s_Night
A_Hard_Day_s_Dalek
A_Miracle_on_Dalekth_Street
A_Shot_in_the_Dalek
A_Streetcar_Named_Dalek
A_Tale_of_Two_Daleks
A_Time_To_Dalek
A_Touch_of_Dalek
A_la_recherche_du_dalek_perdu
A_matter_of_Life_and_Dalek
A_nous_la_Dalek
A_nous_les_petites_Daleks
A_series_of_unfortunate_daleks
A_slipping_down_Dalek
About_a_Dalek
Abre_los_daleks
Ace_Ventura_Pet_Dalek
Ai_no_Dalek
Aleksander_Daleksky
Alexander_the_Dalek
Ali_Baba_and_the_Fourty_Daleks
Alien_vs_Dalek
All_Quiet_on_the_Western_Dalek
All_Your_Dalek_Are_Belong_to_Us
All_in_a_Dalek_s_Work
All_the_Dalek_s_Men
All_the_Kings_Dalek
All_the_President_s_Daleks
All_the_real_Daleks
Allegro_Non_Daleko
Almost_Dalek
Along_came_a_Dalek
Amazon_Daleks_on_the_Moon
Amelie_Dalek
American_Dalek
Amores_Daleks
An_American_Dalek_in_Paris
An_Elastic_Dalek
And_Now_for_Something_Completely_Dalek
And_Then_There_Were_Dalek
Animal_Dalek
Anti_Dalek
Apocalypse_Dalek
Army_of_Daleks
Around_the_Dalek_in_80_Days
Around_the_World_In_80_Daleks
Arsenic_and_Old_Dalek
Artificial_Dalek
Ass_Daleks
At_Play_In_The_Fields_of_the_Daleks
Attack_of_the_Killer_Daleks
Au_Bout_de_Dalek
Austin_Powers_The_Dalek_Who_Shagged_Me
Autobiography_of_a_Dalek
Babette_s_Dalek
Back_to_Dalek
Back_to_the_Dalek
Bad_Daleks
Bad_News_Daleks
Bang_the_Dalek_Slowly
Barton_Dalek
Basic_Dalek
Batman_and_Dalek
Battlefield_Dalek
Battlestar_Dalek
Baz_Luhrmann_s_Dalek_Juliet
Behind_Dalek_Lines
Behind_The_Green_Dalek
Behind_the_Dalek_door
Behind_the_Green_Dalek
Being_Dalek
Being_Dalek_Dalek
Being_Dalek_Malkovich
Being_John_Dalek
Being_John_Dalekovich
Bela_Lugosi_Meets_A_Brooklyn_Dalek
Ben_Dalek
Betten_than_Daleks
Better_Off_Dalek
Beverly_Hills_Dalek
Beyond_the_Valley_of_the_Daleks
BiDalek_Man
Big_Dalek
Big_Dalek_House
Bill_Ted_s_Excellent_Dalek
Biodalek
Birth_of_a_dalek
Black_Dalek_Down
Blazing_Daleks
Blue_Dalekii
Bo_Dalek_in_10
Bob_Carol_Ted_Dalek
Bonnie_and_Dalek
Boogie_Daleks
Boondalek_Saints
Born_to_be_Dalek
Bowling_for_Dalekbine
Bowling_for_Daleks
Boxing_Dalek
Bramstoker_s_Dalek
BraveDalek
Breakfast_at_Daleks
Bridge_over_the_river_Dalek
Bridget_Dalek_and_the_Edge_of_Reason
Bridget_Jones_Dalek
Bring_Dalek_on
Bring_Dalek_on_Again
Bring_Dalek_on_All_or_nothing
Bring_Me_the_Dalek_of_Alfredo_Garcia
Bring_Up_Dalek
Brother_Dalek
Bruce_Lee_The_Dalek_Gang
Buck_Dalek
Buffy_the_Daleks_Slayer
Bulletproof_Dalek
Butch_Cassidy_and_the_Sundalek_Kid
Butch_Dalek_and_the_Sungo_Kid
Caddydalek
Calendar_Daleks
Canadian_Dalek
Capturing_the_Dalek
Carpe_Dalek
Carry_on_Daleking
Carry_on_Up_The_Dalek
Carry_on_Dalek
Casadaleka
Casual_Dalek
Cat_on_a_Hot_Tin_Dalek
Charlie_s_Daleks
Chasing_Dalek
Cheaper_by_the_Dalek
Chez_Dalek
Chicken_Dalek
Children_of_the_Dalek
Chitty_Chitty_Dalek_Dalek
Christmas_with_the_Daleks
Citizen_Dalek
City_of_Daleks
City_of_Lost_Daleks
Clear_and_Present_Dalek
Clifford_the_Big_Red_Dalek
Close_Encounters_of_the_Third_Dalek
Coal_Miner_s_Dalek
Cold_Dalek
Collateral_Dalek
Cool_Daleks
Cool_Hand_Dalek
Cool_Plunger_Dalek
Couch_Daleks
Courage_Under_Dalek
Cowboy_Dalek_Tengoku_No_Tobira
Cradle_2_the_Dalek
Crimson_Dalek
Crocodile_Dalekdee
Crossing_Dalek_with_John_Edward
Crouching_Tiger_Hidden_Dalek
Cruel_Daleks
Cry_the_Beloved_Dalek
DALEK_1138
DALEK_PAX
Dalek
Dalek_The_lost_empire
Dalek_1_2
Dalek_10_from_Navarone
Dalek_12
Dalek_13
Dalek_2
Dalek_2000
Dalek_571
Dalek_9_11
Dalek_911
Dalek_A_E
Dalek_Academy
Dalek_Age
Dalek_Alone
Dalek_At_the_Gates
Dalek_Attack_USA
Dalek_Beauty
Dalek_Brasco
Dalek_Brew
Dalek_Brown
Dalek_Burning
Dalek_by_Law
Dalek_Canyon
Dalek_City
Dalek_Collector
Dalek_Confess
Dalek_Considered_Harmful
Dalek_County_USA
Dalek_Cozens
Dalek_Dalek_Bang_Bang
Dalek_Dancing
Dalek_Day_Afternoon
Dalek_Eye_for_the_Exterminated_Guy
Dalek_Family_Robinson
Dalek_Family_Vacation
Dalek_Fiction
Dalek_For_One
Dalek_Fried_Rice
Dalek_Games
Dalek_Genesis_Evangelion
Dalek_Graffiti
Dalek_Guiness
Dalek_Gully
Dalek_Hall
Dalek_Hard
Dalek_Hard_with_a_vengeance
Dalek_History_X
Dalek_Ho_Tep
Dalek_Hur
Dalek_INC
Dalek_Impossible
Dalek_In_My_Eye
Dalek_In_The_Shell
Dalek_In_The_White_City
Dalek_Instinct
Dalek_Intentions
Dalek_Jones_Diary
Dalek_Jones_The_Edge_of_Reason
Dalek_Little
Dalek_Marklar
Dalek_Me_Amadeus
Dalek_Mnemonic
Dalek_Mononoke
Dalek_Morant
Dalek_Must_Die
Dalek_Muyo
Dalek_Noon
Dalek_Now
Dalek_Off
Dalek_On_The_Beach
Dalek_On_the_Roof
Dalek_Paradiso
Dalek_Park
Dalek_Perversions
Dalek_Pie
Dalek_Powers_2
Dalek_Proof
Dalek_Pryor_Live_in_Concert
Dalek_Q
Dalek_Quest
Dalek_Raider
Dalek_Reloaded
Dalek_Resurection
Dalek_Revolutions
Dalek_Run
Dalek_Run_III
Dalek_Scene_Investigation
Dalek_Shadows
Dalek_Sky
Dalek_Soup
Dalek_Stories
Dalek_Story
Dalek_Tale
Dalek_Theory
Dalek_To_Victory
Dalek_Trebek
Dalek_Violations
Dalek_Wall
Dalek_Wedding
Dalek_Who
Dalek_Willy
Dalek_Window
Dalek_Wish
Dalek_Witch_2
Dalek_Witch_Project
Dalek_Wood
Dalek_and_Bullwinkle
Dalek_and_Clive_Get_The_Horn
Dalek_and_Commander_The_Far_Side_Of_The_World
Dalek_and_Daleker
Dalek_and_Death_on_Long_Island
Dalek_and_Furious
Dalek_and_Greg
Dalek_and_Innocent
Dalek_and_Kumar_go_to_White_Castle
Dalek_and_Persuasion
Dalek_and_Prejudice_obviously
Dalek_and_her_Sisters
Dalek_and_the_Dalek_of_Daleks
Dalek_and_the_Dominoes
Dalek_and_the_Lost_City
Dalek_and_the_Temple_of_Dalek
Dalek_and_the_Temple_of_Doom
Dalek_at_Nuremberg
Dalek_by_Dalekwest
Dalek_des_Sources
Dalek_destroys_earth
Dalek_does_Dallas
Dalek_don_t_live_here_anymore
Dalek_for_the_Prosecution
Dalek_full_of_grace
Dalek_in_Black
Dalek_in_Love
Dalek_in_Manhattan
Dalek_in_My_Hometown
Dalek_in_Paradise
Dalek_in_Pink
Dalek_in_Seattle
Dalek_in_Translation
Dalek_in_Wonderland
Dalek_in_a_Bottle
Dalek_in_the_Rye
Dalek_in_white
Dalek_infinity
Dalek_is_Dalek
Dalek_now
Dalek_of_Arabia
Dalek_of_Montreal
Dalek_of_Red_Cap
Dalek_of_the_Lambs
Dalek_of_the_Opera
Dalek_of_the_Pride
Dalek_of_the_Rings
Dalek_of_the_River_Plate
Dalek_of_the_flies
Dalek_on_34th_Street
Dalek_on_Fire
Dalek_on_the_Bounty
Dalek_on_the_Roof
Dalek_over_the_River_Kwai
Dalek_smile
Dalek_splendor
Dalek_the_Daleks_and_Dalek_them_with_Daleks
Dalek_the_Hedgehog
Dalek_to_Pimlico
Dalek_to_the_Future
Dalek_versus_the_Volcano
Dalek_vs_Jason
Dalek_vs_Mechadalek
Dalek_vs_Aztec_Mummy
Dalek_Dalek_Dalek
Dalek_The_Musical
Dalek_s_11
Dalek_s_Angels
Dalek_s_Army
Dalek_s_Crossing
Dalek_s_Eleven
Dalek_s_Moving_Castle
Dalek_s_On_the_Run
Dalek_s_Party
Dalek_s_Peak
Dalek_s_Really_Big_Movie
Dalek_s_list
Dalek_Interrupted
Dalek_Queen_of_the_Desert
Dalek_22
Dalek_9_P_I
Dalek_First_Blood_Part_II
Dalek_Off_the_Leash
Dalek_The_Exterminating
Dalek_The_Gathering
Dalek_The_Hand_of_Fate
Dalek_the_plunger_of_fate
Daleka
DalekDrome
DalekGate
Dalek_3
Dalekaanisqatsi
Dalekalypse_Now
Dalekatessen
Dalekator
Dalekatraz
Dalekball_Z
Dalekballs
Dalekbees
Dalekblanca
Dalekbound
Dalekburger_Hil
Dalekbusters
Dalekdance
Dalekdevil
Dalekelini
Dalekemon
Dalekerance
Dalekface
Dalekfeld
Dalekfinger
Dalekgarry_Dalek_Ross
Dalekgeddon
Dalekgirl
Dalekgli
Dalekhattan
Dalekheart
Dalekheit_451
Dalekhoe
Dalekhouse_5
Dalekian_Pie
Dalekin_in_the_Rain
Dalekira
Dalekjuice
Dalekless
Dalekma
Dalekman
Dalekmember
Daleknation_Alley
Daleknomicon
Dalekoon
Dalekophenia
Dalekopolis
Dalekpussy
Daleks
Daleks_Are_Forever
Daleks_Attack
Daleks_Courageous
Daleks_Daleks_Daleks_baked_beans_and_Daleks
Daleks_Gone_Wild
Daleks_In_Black
Daleks_In_the_Hood
Daleks_Trebek
Daleks_With_Wolves
Daleks_and_Cents
Daleks_and_Cigarettes
Daleks_and_Fog
Daleks_and_Sense
Daleks_at_Tiffany_s
Daleks_at_the_Gate
Daleks_from_Vienna
Daleks_for_Dummies
Daleks_in_America
Daleks_in_Black
Daleks_in_Pink_Lace
Daleks_in_the_Night
Daleks_in_the_Outfield
Daleks_of_Fire
Daleks_of_Fury
Daleks_of_Madison_County
Daleks_of_a_Summer_Night
Daleks_of_new_york
Daleks_of_the_Carribean
Daleks_of_the_Damned
Daleks_of_the_Valley
Daleks_on_a_Train
Daleks_wide_shut
Daleks_11
Daleks_Inc
Daleks_The_new_beginning
Dalekshack
Daleksport
Dalekspotting
Dalekstar_Galactica
Dalekstine
Dalektastic
Dalektopia
Dalektopussy
Dalektown
Dalekula
Dalekverance
Dalekville
Dalekweenie
Dalekworld
Dalekzander
Dances_with_Daleks
Danger_Dalek
DareDalek
Das_Dalek
Das_Dalekk
Dawn_of_the_Daleks
Day_of_of_the_Daleks
Dead_Dalek_Walking
Dead_Daleks_Society
Dead_and_Dalek_ed
Debbie_Does_Dalek
Debbie_Does_Daleks
Deep_Dalek
Deep_Throat_Daleks
Defeat_of_the_Daleks
Derek_and_the_Daleks
Det_Sjunde_Dalek
Dial_D_for_Dalek
Die_another_dalek
Dirty_Dalek
Dirty_Daleking
Dirty_Daleks
Do_Daleks_have_sex
Do_The_Right_Dalek
Doctor_Dalek
Doctor_Dalek_and_the_Whos
Dog_Dalek_Afternoon
Don_t_Be_A_Dalek_In_South_Central_While_Drinking_Your_Juice_In_The_Hood
Don_t_Say_A_Dalek
Don_t_Tell_Mom_The_Daleksitter_s_Dead
Donnie_Dalek
Dougal_and_the_Blue_Dalek
Dr_Dalek
Dr_Strangedalek_or_How_I_Learned_To_Stop_Worrying_And_Love_Extermination
Dr_Strangedavros_or_How_I_Learned_To_Stop_Worrying_And_Love_The_Dalek
Dr_Zhidalek
Driving_Miss_Dalek
Dude_where_s_my_Dalek
Dungeons_and_Daleks
E_T_the_Extra_Dalek
EXTERMINATE_Hina
Earnest_Saves_Daleks
Earth_Daleks_are_Easy
Easy_Dalek
Eat_Dalek_Man_Dalek
Ed_Dalek
Eddie_Murphy_Dalek
Edward_Dalekhands
Eight_Daleks_Are_Enough
Embrace_of_the_Daleks
Enemy_of_the_Dalek
Enter_the_Dalek
Episode_III_Revenge_of_the_Daleks
Erin_Dalek
Ernest_Goes_to_Dalek
Everything_you_always_wanted_to_know_about_dalek_but_were_afraid_to_ask
Evil_Dalek_III_Army_of_Darkness
Exit_Daleks
Faces_of_Dalek
Falling_Dalek_yet
Family_Dalek
Fanny_and_Dalek
Fast_Times_at_Dalek_High
Faster_Dalek_kill_Kill
Fat_Dalek
Fear_and_Daleks_in_Las_Vegas
Field_of_Dalek
Field_of_Daleks
Finding_Dalek
Finding_Daleks
Fists_of_the_Double_Dalek
Five_Daleks_and_It
Five_Golden_Daleks
Flash_Dalek
Flashdaleks
Flesh_Dalek
Flock_of_Daleks
Fog_of_War_Eleven_Lessons_from_the_life_of_Robert_S_Dalek
For_A_Few_Daleks_More
For_Love_of_the_Dalek
For_a_Few_Daleks_More
Foreign_Dalek
Forget_Dalek
Forrest_Dalek
Four_Daleks
Four_Daleks_and_a_funeral
Four_Daleks_and_a_wedding
Four_Heads_in_a_Dalekbag
Four_Weddings_and_a_Dalek
Freddy_vs_Dalek
Free_Dalek
Friday_Night_Daleks
Fried_Green_Daleks
Friend_Green_Dalek
From_Dalek_to_Eternity
From_Here_to_Dalek
From_the_Earth_to_the_Dalek
Full_Metal_Dalek
Fulltime_Dalek
Gangs_of_New_Dalek
George_Dalek_in_Love
George_of_the_Daleks
Ghost_Dalek
Ghost_Dalek_Way_of_the_Samurai
Ghost_in_the_Dalek
Giant_Dalek_Invasion
Gladalekor
Glendalek_Glenross
Goddalek
Going_Upriver_The_Long_War_of_John_Dalek
Gold_Daleks_of_1933
Goldalek
GoldenDaleks
Gone_is_60_daleks
Gone_with_the_Dalek
Good_Dalek_Hunting
Good_Daleks_Wear_Black
Good_Morning_Dalek
GoodDaleks
Goodbye_Dalek
Grand_Theft_Dalek
Grand_Theft_Dalek_Jelly_Baby_City
Green_Grow_the_Daleks
Gremdaleks
Grosse_Point_Dalek
Groundhog_Dalek
Guess_Who_s_Coming_To_Dalek
Gunga_Dalek
Guys_n_Daleks
H_R_Puf_n_dalek
Habla_con_Dalek
Half_Daleked
Hamburger_Dalek
Hangin_with_the_HomeDaleks
Hanna_and_her_Daleks
Harley_Dalekson_and_the_Marlboro_Man
Harold_and_Dalek_go_to_White_Castle
Harold_and_Kumar_Go_To_White_Dalek
Harry_Potter_and_the_Philosphers_Dalek
Harry_Potter_and_the_Secret_Dalek
Heart_Of_Dalekness
Hearts_of_Dalek_A_Filmmaker_s_Extermination
Heavy_Dalek
Hedwig_and_the_Angry_Dalek
HellDalek
Hello_Dalek
Hey_Dalek
High_Plains_Dalek
Highdalek
Hiroshima_Mon_Dalek
His_Girl_Dalek
History_of_the_Daleks_Part_I
Hold_the_Dalek
Hollywood_Dalekcide
Honey_I_Shrunk_The_Daleks
Honey_I_shrank_the_Daleks
Honey_I_shrunk_the_Daleks
Hook_Line_and_Dalek
Hot_Dalek_in_the
Hot_Daleks
Hot_Shots_Part_Dalek
House_of_Daleks
House_of_a_Thousand_Daleks
House_of_the_Dalek
How_Green_Was_My_Dalek
How_the_Dalek_Stole_Christmas
How_the_Dalek_got_her_Groove_Back
How_the_Grinch_stole_Dalek
Howard_the_Dalek
Hunt_for_the_Dalek_October
Husbands_and_Daleks
I_Know_What_You_Dalek_Last_Summer
I_Was_a_Teenage_Dalek
I_am_a_Fugitive_from_a_Chain_Dalek
I_know_what_the_Daleks_did_last_summer
I_wanna_see_something_about_dalek_diggler
I_m_a_Dalek_get_me_out_of_here
I_Dalek
Ice_station_Dalek_produced_by_howard_Dalek_hughs
If_Daleks_could_kill
Il_Daleko_Rosso
In_Like_Dalek
In_the_Heat_of_the_Dalek
Indecent_Dalek
Independence_Dalek
Indiana_Dalek_and_the_Temple_of_Who
Indiana_Jones_and_the_Temple_of_Dalek
Inspector_Dalek
Interview_With_The_Dalek
Invasion_of_the_Dalek_Snatchers
It_Came_From_Dalek_Space
It_s_A_Wonderful_Dalek
It_s_Dalek_table
It_s_The_Great_Dalek_Charlie_Brown
It_s_a_Mad_Mad_Mad_Dalek
It_s_a_Mad_Mad_Mad_Mad_Dalek
It_s_a_Wonderful_Dalek
Jay_and_Silent_Dalek_strike_back
Jamaica_Dalek
Jerry_McDalek
Jesus_Christ_Superdalek
Joe_versus_The_Dalek
Johnny_Dalekly
Journey_to_the_center_of_the_Dalek
Judge_Dalek
Juno_and_the_Dalek
Kelly_s_Daleks
Kenneth_Moore_as_Davros_in_Reach_for_the_Daleks
Kentucky_Fried_Dalek
Kill_Dalek
Kill_Dalek_Vol_1
Kill_Dalek_Vol_2
Kindergarten_Dalek
Kiss_Kiss_Dalek_Dalek
Kiss_Me_Dalek
Kiss_of_the_Dalek
Knight_Dalek
La_Dalek_Humaine
La_Dalek_Vita
La_Daleka
La_lengua_de_las_Daleks
Ladder_Dalek
Ladri_di_Dalek
Lady_and_the_Dalek
Last_Exit_to_Dalek
Last_of_the_Daleks
Laura_Croft_Tomb_Raider_Cradle_of_Dalek
Law_Order_Special_Daleks_Unit
Law_and_Dalek
Laziness_Impatience_Dalek
Le_Dalek_Rouge
Le_Dalek_Sur_Le_Pont
Le_Rouge_et_La_Dalek
Le_fabuleux_destin_d_Amelie_Dalek
Leathal_Dalek
Legally_Dalek
Les_Daleks_Terribles
Les_Daleks_de_Belleville
Les_Enfants_du_Dalek
Lethal_Dalek
Life_of_Dalek
Like_Dalek_For_Chocolate
Little_Big_Dalek
Little_Dalek_Wants_to_Fly
Little_Dalek_on_the_Prairie
Little_Daleks
Live_and_Let_Dalek
Lock_Stock_and_Two_Smoking_Daleks
Logan_s_Dalek
Lord_of_the_Daleks
Lost_in_Daleks
Lovely_Dalek
Lucia_y_el_Dalek
MacDaleker
Mad_Max_Beyond_ThunderDalek
Maison_EXTERMINATE
Man_Woman_Eat_Dalek
Manos_The_Daleks_of_Fate
Mark_of_Dalek
Mars_needs_Daleks
Max_Dalek_Returns
McDalek_and_Mrs_Miller
Me_without_Dalek
Me_Myself_and_a_Dalek
Mean_Daleks
Meet_Joe_Dalek
Meet_Me_in_St_Dalek
Middledalek
Mighty_Joe_Dalek
Mighty_Morphin_Power_Daleks_The_Movie
Minority_Dalek
Miracle_on_Dalek_Street
Miss_Dalek
Mission_Dalek_2
Mission_to_Dalek
Moby_Dalek
Modern_Dalek
Mommy_Dalek
Monsoon_Dalek
Monty_Python_and_the_Holy_Dalek
Monty_Python_s_Flying_Dalek
Monty_Python_s_Life_of_Dalek
Mortal_Dalek
Morvern_Dalek
Mother_Jugs_and_Daleks
Mr_Dalek_Goes_to_Washington
Mr_Dalek_s_Opus
Mr_Dalek_s_Razed_Neighborhood
Mr_and_Mrs_Dalek
Mrs_Frisby_and_the_Daleks_of_NIMH
Much_Ado_About_Dalek
Mulholland_Dalek
Mutiny_on_the_Dalek
My_Big_Fat_Dalek_Wedding
My_Big_Fat_Greek_Dalek
My_Dalek_Vinny
My_Dalek_With_Andre
My_Dalek_and_Other_Animals
My_Fair_Dalek
My_StepDalek_is_an_Alian
My_beautiful_Dalek
My_big_fat_greek_dalek
My_brother_went_to_Skyro_and_all_I_got_was_this_lousy_dalek
My_dinner_with_dalek
My_Myself_and_Dalek
Mystery_Dalek
Mystic_Dalek
Mystry_Science_Dalek_3000
Mystry_Science_Dalek_3000_The_Movie
Naked_Dalek
Naked_Dalek_2_1_2
National_Lampoon_s_Dalek_Vacation
Natural_Born_Daleks
Neogenesis_Dalek
Never_Say_Dalek
Never_say_dalek_again
Night_Dalek_to_Mundo_Fine
Night_of_the_Living_DAleks
Nightmare_before_Dalekmas
No_Dalek_s_Land
No_Daleks_Barred
No_10_Things_I_Hate_About_Daleks
North_Dalek_Forty
North_by_Northdalek
Not_Another_Dalek_Movie
Now_Daleks
Number_Dalek
O_Dalek_Where_Art_Thou
O_Lucky_Dalek
Of_Daleks_and_Men
Of_Mice_and_Daleks
Office_Dalek
Oh_Dalek_I_love_you_But_we_only_have_6_hours_to_save_the_planet
Oh_Dalek
Oloryn_Crocodile_Dun_Dalek
On_Golden_Dalek
Once_Before_I_Dalek
Once_Upon_a_Dalek_In_The_West
Once_Upon_a_Dalek_In_America
Once_a_Dalek
Once_there_were_daleks
One_Crazy_Dalek
One_Flew_Over_the_Dalek_s_Nest
One_Upon_a_Time_in_Daleko
Ong_Dalek
Only_Daleks_Have_Wings
Or_possibly_Romeo_Dalek
Ordinary_Decent_Dalek
Our_Mutual_Dalek
Out_of_Dalek
Outlaw_Dalek_Whales
Pale_Dalek
Panic_Dalek
Pee_wee_s_Big_Dalek
PerlJam_Daleks
PerlJam_Daleks_Are_Forever
Peter_Dalek
Petticoat_Dalek
Phantom_of_the_Dalek
Pirates_of_the_Carribbean_the_Curse_of_the_Black_Dalek
Pitch_Dalek
Plan_Dalek
Planes_Trains_and_Automodaleks
Planes_Trains_and_Daleks
Planet_of_the_Daleks
Play_Dalek_for_Me
Playboy_Hot_Daleks
Pleasantdalek
Point_Dalek
Police_Academy_Five_Assignment_Dalek_Beach
Porky_s_II_The_Next_Dalek
President_Dalek_the_asshole
Pretty_Dirty_Daleks
Princess_Monobumpy
Programming_Dalek
Pulp_Dalek
Quatermass_and_the_Daleks
Queen_Dalek_tribute_concert
Radio_Dalek
Radioland_Dalek
Raging_Dalek
Raiders_of_the_Lost_Dalek
Raise_your_dalek
RashoDalek
Reach_for_the_Dalek
Rear_Dalek
Red_Dalek
Requiem_for_a_Dalek
Reservoir_Daleks
Resident_Dalek
Revenge_of_the_pink_dalek
Revolution_Dalek
Rich_and_Dalek
Ride_the_High_Dalek
Rikki_Tikki_Dalek
Rita_Sue_and_Dalek_too
Road_Dalek
Rollerdalek
Romancing_the_Dalek
Rooster_Dalekburn
Rosemary_s_Dalek
Run_Dalek_Run
Rush_Dalek
Russian_Dalek
Ryan_s_Dalek
SDalek_17
Santa_Claus_Conquers_the_Daleks
Santa_Claus_Conquers_the_Daleks_on_Mars
Saturday_Dalek_Fever
Save_the_Last_Dalek
Saving_Dalek_s_Privates
Saving_Private_Dalek
Saving_Ryan_s_Daleks
Scardalek
Scared_to_Dalek
Scary_Dalek
Schindler_s_Dalek
Scooby_Dalek
Sea_Dalek
Secret_Dalek
Secrets_and_Daleks
Seed_of_Dalek
Seven_Daleks
Seven_Brides_for_Seven_Daleks
Sex_with_daleks
Sex_Lies_and_Dalek
Sgt_Dalek
Shadow_of_a_Dalek
Shall_we_Dalek
Shallow_Dalek
Shaun_of_the_Daleks
She_Wore_a_Yellow_Dalek
Shipping_Daleks
Short_Dalek
Silent_Dalek
Sinbad_the_Dalek
Singin_in_the_Dalek
Sinners_in_the_Hands_of_an_Angry_Dalek
Sinteen_Daleks
Six_Days_Seven_Daleks
Sky_Master_and_the_Dalek_of_Tomorrow
Slapdalek
Sling_Dalek
Snow_Daleks
Snow_White_and_the_Seven_Daleks
So_I_married_an_Axe_Dalek
Some_Like_it_Dalek
Somewhere_over_the_dalek
Son_of_Dalek
Sophie_s_Dalek
South_Park_Bigger_Longer_and_DALEK
Soylent_Dalek
Space_Daleks
Spartadalek
Spiderdalek
Spinal_Dalek
Star_Trek_II_The_Dalek_of_Khan
Star_Trek_VI_The_Undaleked_Country
Star_Wars_Episode_IV_A_New_Dalek
Star_Wars_Episode_V_The_Dalek_Strikes_Back
Star_Wars_Epsiode_VI_The_Return_Of_The_Dalek
StarDaleks
Steamboat_Dalek
Stop_Making_Daleks
Stop_or_my_Dalek_will_shoot
Strangers_on_a_Dalek
Subdalek
Sundalek
Super_Dalek_Bro
Superdalek
Superdalek_Me
Surf_Nazis_Must_Dalek
Surk_Daleks_Must_Die_rather
Surviving_Dalek
Swallows_and_Daleks
Swimming_With_Daleks
SwordDalek
Take_Care_of_Daleks
Take_My_Advice_The_Dalek_and_Dalek_Story
Talk_Dalek_To_Me
Tank_Dalek
Taxi_Dalek
Team_Dalek_World_Police
Team_Dalek_World_Police_2004
Teenage_Mutant_Ninja_Daleks
Terminator_3_The_Rise_of_the_Daleks
Texas_Dalek_Massacre
That_Obscure_Dalek_of_Desire
That_Think_You_Dalek
The_39_D_D_The_39_Steps
The_39_Daleks
The_6th_Dalek
The_Adventures_of_Dalek_Munchausen
The_Ammityville_Dalek
The_Andromeda_Dalek
The_Art_of_Dalek
The_Bad_News_Bears_Meet_The_Daleks
The_Bad_News_Daleks_Go_to_Japan
The_Best_Little_Dalek_in_Texas
The_Big_Dalek
The_Big_Dalekowski
The_Big_Dalekski
The_Big_Ledalekski
The_Black_Dalek
The_Blair_Dalek_Project
The_Blue_Dalek
The_Breakfast_Dalek
The_Brothers_Dalekazov
The_Cable_Dalek
The_Chronicles_of_Dalek
The_Color_Dalek
The_Cook_the_Thief_His_Wife_Her_Dalek
The_Count_of_Monte_Dalek
The_Crying_Dalek
The_Curious_Incident_of_the_Dalek_in_the_Night
The_Curse_of_the_Black_Dalek
The_Dalek
The_Dalek_After_Tomorrow
The_Dalek_Always_Rings_Twice
The_Dalek_Before_Christmas
The_Dalek_Brothers
The_Dalek_Case
The_Dalek_Children
The_Dalek_Club
The_Dalek_Collector
The_Dalek_Company
The_Dalek_Crown_Affair
The_Dalek_Crystal
The_Dalek_Effect
The_Dalek_Escape
The_Dalek_Express
The_Dalek_Game
The_Dalek_Identity
The_Dalek_Invasion_Of_Earth
The_Dalek_Job
The_Dalek_Josey_Wales
The_Dalek_King
The_Dalek_Knight
The_Dalek_Machine
The_Dalek_Mile
The_Dalek_Mutiny
The_Dalek_Nikita
The_Dalek_Patient
The_Dalek_Redemption
The_Dalek_Reloaded
The_Dalek_Remains_the_Same
The_Dalek_Returns
The_Dalek_Show
The_Dalek_Storm
The_Dalek_Stuff
The_Dalek_Suicides
The_Dalek_Supremacy
The_Dalek_Syndrome
The_Dalek_Trap
The_Dalek_Vanishes
The_Dalek_Upstairs
The_Dalek_Whisperer
The_Dalek_Who_Came_to_Dinner
The_Dalek_Who_Came_in_From_the_Cold
The_Dalek_Who_Exterminated_Me
The_Dalek_Who_Knew_Too_Much
The_Dalek_Who_Leapt_Through_Time
The_Dalek_Who_Stole_Christmas
The_Dalek_With_Teh_Golden_Plunger
The_Dalek_Wore_Tennis_Shoes
The_Dalek_and_Daniel_Webster
The_Dalek_from_the_Black_Lagoon
The_Dalek_has_landed
The_Dalek_in_the_Hat
The_Dalek_in_the_White_Suit
The_Dalek_in_the_Willows
The_Dalek_in_the_Window
The_Dalek_next_door
The_Dalek_of_Dr_Caligieri
The_Dalek_of_Notre_Dam
The_Dalek_of_Oz
The_Dalek_of_the_Baskervilles
The_Dalek_that_Wouldn_t_Die
The_Dalek_who_shot_Liberty_Valance
The_Dalek_who_wasn_t_there
The_Dalek_s_Advocate
The_Dalek_s_Daughter
The_Dalek_the_Dalek_his_Dalek_and_her_Dalek
The_Dalek_the_Dalek_the_Dalek_and_her_Dalek
The_Dalekbusters
The_Dalekhead
The_Dalekhouse
The_Dalekillers
The_Daleking
The_Dalekityville_Horror
The_Daleks_Have_Eyes
The_Daleks_Must_Be_Crazy
The_Daleks_Strike_Back
The_Daleks_Take_Manhattan
The_Daleks_Under_the_Stairs
The_Daleks_new_groove
The_Daleks_of_Eastwick
The_Daleks_of_Fear
The_Daleks_of_Flatbush
The_Daleks_of_Navarone
The_Daleks_of_Summer
The_Daleks_of_Wrath
The_Dalekship_Potemkin
The_Daleksitters_club
The_Dalektrix
The_Dark_Dalek
The_Day_of_the_Dalek
The_Day_the_Dalek_Stood_Still
The_Day_the_Daleks_Caught_Fire
The_Day_the_Daleks_Stood_Still
The_Desert_Daleks
The_Diary_of_Anne_Dalek
The_Divine_Secrets_Of_The_Dalek_Sisterhood
The_Eternal_Sunshine_of_the_Dalek_Mind
The_Eternal_Sunshine_of_the_Spotless_Dalek
The_Evil_Daleks
The_Evil_that_Daleks_Do
The_Fast_And_The_Dalek
The_Fisher_Dalek
The_Forbidden_Dalek
The_Four_Dalekteers
The_French_Dalektion
The_Full_Dalek
The_Gay_Dalekee
The_Ghost_and_mrs_Dalek
The_Girl_Who_Leapt_Through_Dalek
The_Goddalek
The_Gods_Must_Be_Daleks
The_Good_Dalek
The_Good_Old_Naughty_Dalek
The_Good_The_Bad_and_The_Dalek
The_Great_Dalek_Caper
The_Haunted_Dalek
The_Heart_of_Dalek
The_Hidden_Dalek
The_Hound_of_the_Dalekvilles
The_Hudsucker_Dalek
The_Hunt_for_Red_Dalek
The_Incredibly_Strange_Creatures_Who_Stopped_Living_And_Became_Mixed_Up_Daleks
The_Invisible_Dalek
The_Iron_Dalek
The_Island_of_Dr_Dalek
The_Italian_Dalek
The_Land_That_Dalek_Forgot
The_Last_Action_Dalek
The_Last_Dalek
The_Last_Dalek_Virgin
The_Last_Dalek_of_Christ
The_Last_Dalekfighter
The_League_of_Extraordinary_Daleks
The_Legend_of_Bagger_Dalek
The_Legend_of_Drunken_Dalek
The_Legend_of_Robin_Dalek
The_Life_and_Death_of_Colonel_Dalek
The_Life_of_Dalek
The_Life_of_David_Dalek
The_Little_Dalek_that_could
The_Longest_Dalek
The_Looney_Looney_Looney_Bugs_Dalek_Movie
The_Lost_Daleks
The_Love_Dalek
The_Magnificent_Dalek
The_Maltese_Dalek
The_Man_Who_Shot_Liberty_Dalek
The_Man_Who_Would_Be_Dalek
The_Man_in_the_Iron_Dalek
The_Man_with_One_Red_Dalek
The_Manchurian_Dalek
The_Marriage_of_Dalek_Von_Braun
The_Mask_of_Dalek
The_Midwich_Daleks
The_Mighty_Daleks
The_Mountain_Dalek
The_Mysterious_Mr_Dalek
The_Name_of_the_Dalek
The_Neverending_Dalek
The_Night_of_The_Dalek
The_Old_Man_and_the_Dalek
The_Once_and_Future_Dalek
The_Opening_of_Dalek_Beethoven
The_Ox_bow_Dalek
The_Palm_Beach_Dalek
The_Passion_of_the_Dalek
The_Pink_Dalek
The_Pleasure_Dalek
The_Polar_Dalek
The_President_s_Dalek
The_Princess_Dalek
The_Quiet_Dalek
The_Red_Daleks
The_Remains_of_the_Dalek
The_Replacement_Daleks
The_Right_Dalek
The_Rising_Dalek
The_Rocky_Dalek_Picture_Show
The_Royal_Dalekbaums
The_Runaway_Dalek
The_Running_Dalek
The_Scent_of_a_Dalek
The_Secret_of_Dalek
The_Seven_Dalek
The_Seventh_Dalek
The_Shaggy_Dalek_A
The_Shape_of_Daleks_to_Come
The_Silence_of_the_Daleks
The_Sixth_Dalek
The_Station_Dalek
The_Story_of_Dalek_of_Arc
The_Sungoshank_Dalektion
The_Sure_hand_of_dalek
The_Sweet_HereDalek
The_Sweet_Smell_of_Dalek
The_Talented_Mr_Dalek
The_Ten_Command_Daleks
The_Thief_of_BaghDalek
The_Thin_Blue_Dalek
The_Thin_Dalek
The_Three_Dalekateers
The_Three_Daleks
The_Times_of_Harvey_Dalek
The_Titfield_Dalek
The_Treasure_of_the_Sierra_Dalek
The_Trouble_with_Dalek
The_UnDalek
The_Unbelievable_Dalek
The_Undearable_Dalek_of_Being
The_Undearable_Dalek_of_Dalek
The_Usual_Daleks
The_Virgin_Daleks
The_Wages_of_Dalek
The_Wedding_Dalek
The_Werdaleks_of_London
The_Whole_Nine_Daleks
The_Wicker_Dalek
The_Wild_Daleks
The_Wild_World_of_Dalekwoman
The_Wrong_Dalek
The_Year_of_Living_Dalekly
The_business_of_Dalek
The_count_of_monte_Dalek
The_Last_Dalek_of_Cadavra
The_name_of_the_Dalek
The_passion_of_Dalek
The_return_of_the_Texas_Dalek_Massacre
The_sound_of_dalek
The_sweetest_dalek
Theory_the_princess_dalek
There_s_Something_About_Daleks
Thin_Red_Dalek
Things_To_Do_In_Dalek_When_You_re_Dead
Thirty_Daleks_Over_Tokyo
This_Island_Dalek
This_Planet_Dalek
Those_Damn_Daleks
Three_Daleks_and_a_Baby
Three_Daleks_Blue
Three_Daleks_Red
Three_Daleks_White
Throw_Dalek_From_the_Train
Tiki_Tiki_Dalek
Tin_Daleks
To_Catch_a_Dalek
To_Dalek_a_mockingbird
To_Dalek_and_Dalek_Not
To_Dalek_or_not_to_Dalek
To_Kill_A_Dalek
To_Kill_a_Mocking_Dalek
Tom_Dalek
Tomb_Dalek
Top_Dalek
Torn_Dalek
Trading_Daleks
Traindaleking
Training_Dalek
Triumph_of_the_Dalek
Trois_couleurs_Dalek
True_Dalek
Truth_about_Daleks_and_Daleks
Tubdalek
Turner_and_Dalek
Twelve_Angry_Daleks
Twenty_Seven_Daleks
Two_Daleks_for_Sister_Sara
UHDalek
Uh_Dalektraz
Uncle_Dalek
Undalekable
Under_Siege_2_Dalek_Territory
UnderDalek
Universal_Dalek
Valley_of_the_Daleks
Van_Daleker
Van_Dalek_the_London_assignment
Varsity_Daleks
VertiDalek
Vertical_Dalek
Village_of_the_Daleks
Wag_the_Dalek
Waiting_for_Dalek
Walk_like_a_Dalek
Wallace_Dalek
War_and_Daleks
Watership_Dalek
Wayne_s_Dalek
Weekend_Daleks
Weird_Dalek
West_Side_Dalek
Whale_Dalek
What_About_Dalek
What_Daleks_Beneath
What_a_Dalek_Wants
When_Daleks_Met_Sally
When_Harry_met_Dalek
When_We_Were_Daleks
Where_Daleks_Dare
Where_the_Daleks_Are
White_Daleks
White_Daleks_Can_t_Jump
Who_Framed_Roger_Dalek
Who_Framed_Dalek_Rabit
Who_s_Afraid_of_Virginia_Dalek
Who_s_that_Dalek
Who_s_the_Dalek
Wild_Dalekberries
Wild_Wild_Dalek
Willy_Wonka_and_the_Dalek_Factory
Willy_Wonka_and_the_Glass_Dalek
With_Six_You_Get_Dalek
X_Daleks
Y_Tu_Dalek_Tambien
Yaakov_Dalek_on_a_Hot_Tin_Roof
Yet_Another_Dalek_Channel_North_America
Yet_Another_Dalek_Movie
Yom_Dalekpur
You_Only_Dalek_Twice
You_ve_got_Dalek
Young_Dalekstein
Yu_Mama_Dalek
Yu_Gi_Dalek
ZarDalek
Zorba_the_Dalek
