package Color::Library::Dictionary::NBS_ISCC::RC;

use strict;
use warnings;

use base qw/Color::Library::Dictionary/;

__PACKAGE__->_register_dictionary;

package Color::Library::Dictionary::NBS_ISCC::RC;

=pod

=head1 NAME

Color::Library::Dictionary::NBS_ISCC::RC - (NBS/ISCC RC) Rock-Color Chart

=head1 DESCRIPTION

    Kenneth L. Kelly and Deanne B. Judd.
    "Color: Universal Language and Dictionary of Names",
    National Bureau of Standards,
    Spec. Publ. 440, Dec. 1976, 189 pages.


    Color Name Dictionary: (RC) Rock-Color Chart

    National Research Council,
    Rock-Color Chart 

This combinatorial field-work dictionary's 95 names map to 120 colors, using 89 of 267 centoids. This is less redundant than the others. Unfortunately, the focus on rock colors will not make for a general purpose dictionary.

L<http://swissnet.ai.mit.edu/~jaffer/Color/Dictionaries#RC>

=head1 COLORS

	black                    black                  #222222

	blackish red             blackishred            #543d3f

	bluish white             bluishwhite            #e9e9ed

	brilliant green          brilliantgreen         #6aab8e

	brownish black           brownishblack          #3e322c

	brownish gray            brownishgray           #5b504f

	dark greenish gray       darkgreenishgray       #5e716a

	dark greenish gray       darkgreenishgray       #4e5755

	dark greenish yellow     darkgreenishyellow     #98943e

	dark reddish brown       darkreddishbrown       #79443b

	dark yellowish brown     darkyellowishbrown     #7e6d5a

	dark yellowish green     darkyellowishgreen     #355e3b

	dark yellowish orange    darkyellowishorange    #be8a3d

	dusky blue               duskyblue              #536878

	dusky blue               duskyblue              #36454f

	dusky blue-green         duskybluegreen         #3a4b47

	dusky brown              duskybrown             #3e322c

	dusky green              duskygreen             #1b4d3e

	dusky red                duskyred               #722f37

	dusky yellow             duskyyellow            #a18f60

	dusky yellow green       duskyyellowgreen       #8f9779

	dusky yellowish brown    duskyyellowishbrown    #483c32

	dusky yellowish green    duskyyellowishgreen    #355e3b

	dusky yellowish green    duskyyellowishgreen    #3a4b47

	grayish black            grayishblack           #222222

	grayish blue             grayishblue            #536878

	grayish blue             grayishblue            #8c92ac

	grayish blue-green       grayishbluegreen       #5e716a

	grayish blue-green       grayishbluegreen       #317873

	grayish brown            grayishbrown           #635147

	grayish green            grayishgreen           #5e716a

	grayish green            grayishgreen           #317873

	grayish olive            grayisholive           #5b5842

	grayish olive green      grayisholivegreen      #515744

	grayish orange           grayishorange          #c19a6b

	grayish orange pink      grayishorangepink      #c7ada3

	grayish pink             grayishpink            #ead8d7

	grayish purple           grayishpurple          #796878

	grayish red              grayishred             #905d5d

	grayish red              grayishred             #674c47

	grayish red purple       grayishredpurple       #796878

	grayish yellow           grayishyellow          #c2b280

	grayish yellow green     grayishyellowgreen     #8f9779

	greenish black           greenishblack          #31362b

	greenish black           greenishblack          #3a4b47

	greenish black           greenishblack          #1a2421

	greenish black           greenishblack          #4e5755

	greenish black           greenishblack          #1e2321

	greenish gray            greenishgray           #8da399

	greenish gray            greenishgray           #7d8984

	light blue               lightblue              #66aabc

	light blue green         lightbluegreen         #66ada4

	light bluish gray        lightbluishgray        #b4bcc0

	light brown              lightbrown             #ae6938

	light brown              lightbrown             #a67b5b

	light brownish gray      lightbrownishgray      #8e8279

	light gray               lightgray              #b9b8b5

	light green              lightgreen             #6aab8e

	light greenish gray      lightgreenishgray      #b2beb5

	light olive              lightolive             #867e36

	light olive brown        lightolivebrown        #867e36

	light olive-gray         lightolivegray         #8e8279

	light olive-gray         lightolivegray         #8a8776

	light red                lightred               #c08081

	medium bluish gray       mediumbluishgray       #81878b

	medium gray              mediumgray             #848482

	medium gray              mediumgray             #555555

	medium light gray        mediumlightgray        #848482

	moderate blue            moderateblue           #367588

	moderate blue green      moderatebluegreen      #317873

	moderate brown           moderatebrown          #6f4e37

	moderate green           moderategreen          #3b7861

	moderate greenish yellow moderategreenishyellow #b9b57d

	moderate olive brown     moderateolivebrown     #665d1e

	moderate orange pink     moderateorangepink     #f4c2c2

	moderate orange pink     moderateorangepink     #d9a6a9

	moderate pink            moderatepink           #dea5a4

	moderate red             moderatered            #905d5d

	moderate reddish brown   moderatereddishbrown   #9e4732

	moderate reddish orange  moderatereddishorange  #b4745e

	moderate yellow          moderateyellow         #c9ae5d

	moderate yellow green    moderateyellowgreen    #8a9a5b

	moderate yellowish brown moderateyellowishbrown #826644

	moderate yellowish green moderateyellowishgreen #679267

	olive black              oliveblack             #363527

	olive black              oliveblack             #57554c

	olive gray               olivegray              #57554c

	pale blue                paleblue               #66aabc

	pale blue                paleblue               #91a3b0

	pale blue green          palebluegreen          #8da399

	pale brown               palebrown              #977f73

	pale green               palegreen              #8da399

	pale greenish yellow     palegreenishyellow     #dadfb7

	pale olive               paleolive              #8c8767

	pale pink                palepink               #e8ccd7

	pale purple              palepurple             #aa98a9

	pale red                 palered                #ad8884

	pale red                 palered                #977f73

	pale reddish brown       palereddishbrown       #a87c6d

	pale red purple          paleredpurple          #aa98a9

	pale yellowish brown     paleyellowishbrown     #ae9b82

	pale yellowish green     paleyellowishgreen     #8da399

	pale yellowish orange    paleyellowishorange    #fad6a5

	pinkish gray             pinkishgray            #c1b6b3

	very dark red            verydarkred            #722f37

	very dusky purple        veryduskypurple        #563c5c

	very dusky purple        veryduskypurple        #50404d

	very dusky purple        veryduskypurple        #291e29

	very dusky red           veryduskyred           #674c47

	very dusky red           veryduskyred           #43302e

	very dusky red purple    veryduskyredpurple     #50404d

	very dusky red purple    veryduskyredpurple     #291e29

	very dusky red purple    veryduskyredpurple     #673147

	very dusky red purple    veryduskyredpurple     #38152c

	very light gray          verylightgray          #b9b8b5

	very pale blue           verypaleblue           #bcd4e6

	very pale green          verypalegreen          #c7e6d7

	very pale orange         verypaleorange         #bfb8a5

	white                    white                  #f2f3f4

	yellowish gray           yellowishgray          #bfb8a5


=cut

sub _load_color_list() {
    return [
['nbs-iscc-rc:black.267','black','black',[34,34,34],'222222',2236962],
['nbs-iscc-rc:blackishred.20','blackishred','blackish red',[84,61,63],'543d3f',5520703],
['nbs-iscc-rc:bluishwhite.189','bluishwhite','bluish white',[233,233,237],'e9e9ed',15329773],
['nbs-iscc-rc:brilliantgreen.144','brilliantgreen','brilliant green',[106,171,142],'6aab8e',6990734],
['nbs-iscc-rc:brownishblack.62','brownishblack','brownish black',[62,50,44],'3e322c',4076076],
['nbs-iscc-rc:brownishgray.64','brownishgray','brownish gray',[91,80,79],'5b504f',5984335],
['nbs-iscc-rc:darkgreenishgray.150','darkgreenishgray','dark greenish gray',[94,113,106],'5e716a',6189418],
['nbs-iscc-rc:darkgreenishgray.156','darkgreenishgray','dark greenish gray',[78,87,85],'4e5755',5134165],
['nbs-iscc-rc:darkgreenishyellow.103','darkgreenishyellow','dark greenish yellow',[152,148,62],'98943e',9999422],
['nbs-iscc-rc:darkreddishbrown.43','darkreddishbrown','dark reddish brown',[121,68,59],'79443b',7947323],
['nbs-iscc-rc:darkyellowishbrown.80','darkyellowishbrown','dark yellowish brown',[126,109,90],'7e6d5a',8285530],
['nbs-iscc-rc:darkyellowishgreen.137','darkyellowishgreen','dark yellowish green',[53,94,59],'355e3b',3497531],
['nbs-iscc-rc:darkyellowishorange.72','darkyellowishorange','dark yellowish orange',[190,138,61],'be8a3d',12487229],
['nbs-iscc-rc:duskyblue.186','duskyblue','dusky blue',[83,104,120],'536878',5466232],
['nbs-iscc-rc:duskyblue.187','duskyblue','dusky blue',[54,69,79],'36454f',3556687],
['nbs-iscc-rc:duskybluegreen.151','duskybluegreen','dusky blue-green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-rc:duskybrown.62','duskybrown','dusky brown ',[62,50,44],'3e322c',4076076],
['nbs-iscc-rc:duskygreen.146','duskygreen','dusky green',[27,77,62],'1b4d3e',1789246],
['nbs-iscc-rc:duskyred.16','duskyred','dusky red',[114,47,55],'722f37',7483191],
['nbs-iscc-rc:duskyyellow.91','duskyyellow','dusky yellow',[161,143,96],'a18f60',10588000],
['nbs-iscc-rc:duskyyellowgreen.122','duskyyellowgreen','dusky yellow green',[143,151,121],'8f9779',9410425],
['nbs-iscc-rc:duskyyellowishbrown.81','duskyyellowishbrown','dusky yellowish brown',[72,60,50],'483c32',4734002],
['nbs-iscc-rc:duskyyellowishgreen.137','duskyyellowishgreen','dusky yellowish green',[53,94,59],'355e3b',3497531],
['nbs-iscc-rc:duskyyellowishgreen.151','duskyyellowishgreen','dusky yellowish green',[58,75,71],'3a4b47',3820359],
['nbs-iscc-rc:grayishblack.267','grayishblack','grayish black',[34,34,34],'222222',2236962],
['nbs-iscc-rc:grayishblue.186','grayishblue','grayish blue',[83,104,120],'536878',5466232],
['nbs-iscc-rc:grayishblue.203','grayishblue','grayish blue',[140,146,172],'8c92ac',9212588],
['nbs-iscc-rc:grayishbluegreen.150','grayishbluegreen','grayish blue-green',[94,113,106],'5e716a',6189418],
['nbs-iscc-rc:grayishbluegreen.164','grayishbluegreen','grayish blue-green',[49,120,115],'317873',3242099],
['nbs-iscc-rc:grayishbrown.61','grayishbrown','grayish brown',[99,81,71],'635147',6508871],
['nbs-iscc-rc:grayishgreen.150','grayishgreen','grayish green',[94,113,106],'5e716a',6189418],
['nbs-iscc-rc:grayishgreen.164','grayishgreen','grayish green',[49,120,115],'317873',3242099],
['nbs-iscc-rc:grayisholive.110','grayisholive','grayish olive',[91,88,66],'5b5842',5986370],
['nbs-iscc-rc:grayisholivegreen.127','grayisholivegreen','grayish olive green',[81,87,68],'515744',5330756],
['nbs-iscc-rc:grayishorange.76','grayishorange','grayish orange',[193,154,107],'c19a6b',12687979],
['nbs-iscc-rc:grayishorangepink.32','grayishorangepink','grayish orange pink',[199,173,163],'c7ada3',13086115],
['nbs-iscc-rc:grayishpink.7','grayishpink','grayish pink',[234,216,215],'ead8d7',15390935],
['nbs-iscc-rc:grayishpurple.228','grayishpurple','grayish purple',[121,104,120],'796878',7956600],
['nbs-iscc-rc:grayishred.19','grayishred','grayish red',[144,93,93],'905d5d',9461085],
['nbs-iscc-rc:grayishred.46','grayishred','grayish red',[103,76,71],'674c47',6769735],
['nbs-iscc-rc:grayishredpurple.228','grayishredpurple','grayish red purple',[121,104,120],'796878',7956600],
['nbs-iscc-rc:grayishyellow.90','grayishyellow','grayish yellow',[194,178,128],'c2b280',12759680],
['nbs-iscc-rc:grayishyellowgreen.122','grayishyellowgreen','grayish yellow green ',[143,151,121],'8f9779',9410425],
['nbs-iscc-rc:greenishblack.128','greenishblack','greenish black',[49,54,43],'31362b',3225131],
['nbs-iscc-rc:greenishblack.151','greenishblack','greenish black',[58,75,71],'3a4b47',3820359],
['nbs-iscc-rc:greenishblack.152','greenishblack','greenish black',[26,36,33],'1a2421',1713185],
['nbs-iscc-rc:greenishblack.156','greenishblack','greenish black',[78,87,85],'4e5755',5134165],
['nbs-iscc-rc:greenishblack.157','greenishblack','greenish black',[30,35,33],'1e2321',1975073],
['nbs-iscc-rc:greenishgray.149','greenishgray','greenish gray',[141,163,153],'8da399',9282457],
['nbs-iscc-rc:greenishgray.155','greenishgray','greenish gray',[125,137,132],'7d8984',8227204],
['nbs-iscc-rc:lightblue.172','lightblue','light blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-rc:lightbluegreen.163','lightbluegreen','light blue green',[102,173,164],'66ada4',6729124],
['nbs-iscc-rc:lightbluishgray.190','lightbluishgray','light bluish gray',[180,188,192],'b4bcc0',11844800],
['nbs-iscc-rc:lightbrown.54','lightbrown','light brown',[174,105,56],'ae6938',11430200],
['nbs-iscc-rc:lightbrown.57','lightbrown','light brown',[166,123,91],'a67b5b',10910555],
['nbs-iscc-rc:lightbrownishgray.63','lightbrownishgray','light brownish gray',[142,130,121],'8e8279',9339513],
['nbs-iscc-rc:lightgray.264','lightgray','light gray',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-rc:lightgreen.144','lightgreen','light green',[106,171,142],'6aab8e',6990734],
['nbs-iscc-rc:lightgreenishgray.154','lightgreenishgray','light greenish gray',[178,190,181],'b2beb5',11714229],
['nbs-iscc-rc:lightolive.106','lightolive','light olive',[134,126,54],'867e36',8814134],
['nbs-iscc-rc:lightolivebrown.106','lightolivebrown','light olive brown',[134,126,54],'867e36',8814134],
['nbs-iscc-rc:lightolivegray.63','lightolivegray','light olive-gray',[142,130,121],'8e8279',9339513],
['nbs-iscc-rc:lightolivegray.112','lightolivegray','light olive-gray',[138,135,118],'8a8776',9078646],
['nbs-iscc-rc:lightred.6','lightred','light red',[192,128,129],'c08081',12615809],
['nbs-iscc-rc:mediumbluishgray.191','mediumbluishgray','medium bluish gray',[129,135,139],'81878b',8488843],
['nbs-iscc-rc:mediumgray.265','mediumgray','medium gray',[132,132,130],'848482',8684674],
['nbs-iscc-rc:mediumgray.266','mediumgray','medium gray',[85,85,85],'555555',5592405],
['nbs-iscc-rc:mediumlightgray.265','mediumlightgray','medium light gray ',[132,132,130],'848482',8684674],
['nbs-iscc-rc:moderateblue.173','moderateblue','moderate blue',[54,117,136],'367588',3569032],
['nbs-iscc-rc:moderatebluegreen.164','moderatebluegreen','moderate blue green',[49,120,115],'317873',3242099],
['nbs-iscc-rc:moderatebrown.58','moderatebrown','moderate brown',[111,78,55],'6f4e37',7294519],
['nbs-iscc-rc:moderategreen.145','moderategreen','moderate green',[59,120,97],'3b7861',3897441],
['nbs-iscc-rc:moderategreenishyellow.105','moderategreenishyellow','moderate greenish yellow',[185,181,125],'b9b57d',12170621],
['nbs-iscc-rc:moderateolivebrown.107','moderateolivebrown','moderate olive brown',[102,93,30],'665d1e',6708510],
['nbs-iscc-rc:moderateorangepink.28','moderateorangepink','moderate orange pink',[244,194,194],'f4c2c2',16040642],
['nbs-iscc-rc:moderateorangepink.29','moderateorangepink','moderate orange pink',[217,166,169],'d9a6a9',14263977],
['nbs-iscc-rc:moderatepink.5','moderatepink','moderate pink',[222,165,164],'dea5a4',14591396],
['nbs-iscc-rc:moderatered.19','moderatered','moderate red',[144,93,93],'905d5d',9461085],
['nbs-iscc-rc:moderatereddishbrown.38','moderatereddishbrown','moderate reddish brown',[158,71,50],'9e4732',10372914],
['nbs-iscc-rc:moderatereddishorange.39','moderatereddishorange','moderate reddish orange',[180,116,94],'b4745e',11826270],
['nbs-iscc-rc:moderateyellow.87','moderateyellow','moderate yellow',[201,174,93],'c9ae5d',13217373],
['nbs-iscc-rc:moderateyellowgreen.120','moderateyellowgreen','moderate yellow green',[138,154,91],'8a9a5b',9083483],
['nbs-iscc-rc:moderateyellowishbrown.77','moderateyellowishbrown','moderate yellowish brown',[130,102,68],'826644',8545860],
['nbs-iscc-rc:moderateyellowishgreen.136','moderateyellowishgreen','moderate yellowish green',[103,146,103],'679267',6787687],
['nbs-iscc-rc:oliveblack.111','oliveblack','olive black',[54,53,39],'363527',3552551],
['nbs-iscc-rc:oliveblack.113','oliveblack','olive black',[87,85,76],'57554c',5723468],
['nbs-iscc-rc:olivegray.113','olivegray','olive gray',[87,85,76],'57554c',5723468],
['nbs-iscc-rc:paleblue.172','paleblue','pale blue',[102,170,188],'66aabc',6728380],
['nbs-iscc-rc:paleblue.185','paleblue','pale blue',[145,163,176],'91a3b0',9544624],
['nbs-iscc-rc:palebluegreen.149','palebluegreen','pale blue green',[141,163,153],'8da399',9282457],
['nbs-iscc-rc:palebrown.45','palebrown','pale brown',[151,127,115],'977f73',9928563],
['nbs-iscc-rc:palegreen.149','palegreen','pale green',[141,163,153],'8da399',9282457],
['nbs-iscc-rc:palegreenishyellow.121','palegreenishyellow','pale greenish yellow',[218,223,183],'dadfb7',14344119],
['nbs-iscc-rc:paleolive.109','paleolive','pale olive',[140,135,103],'8c8767',9209703],
['nbs-iscc-rc:palepink.252','palepink','pale pink',[232,204,215],'e8ccd7',15256791],
['nbs-iscc-rc:palepurple.227','palepurple','pale purple',[170,152,169],'aa98a9',11180201],
['nbs-iscc-rc:palered.18','palered','pale red',[173,136,132],'ad8884',11372676],
['nbs-iscc-rc:palered.45','palered','pale red',[151,127,115],'977f73',9928563],
['nbs-iscc-rc:palereddishbrown.42','palereddishbrown','pale reddish brown',[168,124,109],'a87c6d',11041901],
['nbs-iscc-rc:paleredpurple.227','paleredpurple','pale red purple ',[170,152,169],'aa98a9',11180201],
['nbs-iscc-rc:paleyellowishbrown.79','paleyellowishbrown','pale yellowish brown',[174,155,130],'ae9b82',11443074],
['nbs-iscc-rc:paleyellowishgreen.149','paleyellowishgreen','pale yellowish green',[141,163,153],'8da399',9282457],
['nbs-iscc-rc:paleyellowishorange.73','paleyellowishorange','pale yellowish orange',[250,214,165],'fad6a5',16438949],
['nbs-iscc-rc:pinkishgray.10','pinkishgray','pinkish gray',[193,182,179],'c1b6b3',12695219],
['nbs-iscc-rc:verydarkred.16','verydarkred','very dark red',[114,47,55],'722f37',7483191],
['nbs-iscc-rc:veryduskypurple.224','veryduskypurple','very dusky purple',[86,60,92],'563c5c',5651548],
['nbs-iscc-rc:veryduskypurple.229','veryduskypurple','very dusky purple',[80,64,77],'50404d',5259341],
['nbs-iscc-rc:veryduskypurple.230','veryduskypurple','very dusky purple',[41,30,41],'291e29',2694697],
['nbs-iscc-rc:veryduskyred.46','veryduskyred','very dusky red',[103,76,71],'674c47',6769735],
['nbs-iscc-rc:veryduskyred.47','veryduskyred','very dusky red',[67,48,46],'43302e',4403246],
['nbs-iscc-rc:veryduskyredpurple.229','veryduskyredpurple','very dusky red purple',[80,64,77],'50404d',5259341],
['nbs-iscc-rc:veryduskyredpurple.230','veryduskyredpurple','very dusky red purple',[41,30,41],'291e29',2694697],
['nbs-iscc-rc:veryduskyredpurple.259','veryduskyredpurple','very dusky red purple',[103,49,71],'673147',6762823],
['nbs-iscc-rc:veryduskyredpurple.260','veryduskyredpurple','very dusky red purple',[56,21,44],'38152c',3675436],
['nbs-iscc-rc:verylightgray.264','verylightgray','very light gray',[185,184,181],'b9b8b5',12171445],
['nbs-iscc-rc:verypaleblue.184','verypaleblue','very pale blue',[188,212,230],'bcd4e6',12375270],
['nbs-iscc-rc:verypalegreen.148','verypalegreen','very pale green',[199,230,215],'c7e6d7',13100759],
['nbs-iscc-rc:verypaleorange.93','verypaleorange','very pale orange',[191,184,165],'bfb8a5',12564645],
['nbs-iscc-rc:white.263','white','white',[242,243,244],'f2f3f4',15922164],
['nbs-iscc-rc:yellowishgray.93','yellowishgray','yellowish gray',[191,184,165],'bfb8a5',12564645]
    ];
}

sub _description {
    return {
          'subtitle' => 'Rock-Color Chart',
          'title' => 'NBS/ISCC RC',
          'description' => '    Kenneth L. Kelly and Deanne B. Judd.
    "Color: Universal Language and Dictionary of Names",
    National Bureau of Standards,
    Spec. Publ. 440, Dec. 1976, 189 pages.


    Color Name Dictionary: (RC) Rock-Color Chart

    National Research Council,
    Rock-Color Chart 

This combinatorial field-work dictionary\'s 95 names map to 120 colors, using 89 of 267 centoids. This is less redundant than the others. Unfortunately, the focus on rock colors will not make for a general purpose dictionary.

[http://swissnet.ai.mit.edu/~jaffer/Color/Dictionaries#RC]
'
        }

}

1;
