use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'LNATION',
    DISTNAME         => 'LNATION',
    VERSION          => '0.05',
    ABSTRACT         => 'Ancient Perl',
    MIN_PERL_VERSION => '5.014',
    AUTHOR       => 'LNATION <email@lnation.org>',
    LICENSE      => 'perl_5',
    macro        => { TARFLAGS => "--format=ustar -c -v -f" },
    DIR          => [qw(xs/slot xs/util xs/noop xs/const xs/doubly xs/object xs/lru)],
    META_MERGE   => {
        'meta-spec' => { version => 2 },
        provides => {
            'slot' => {
                file    => 'lib/slot.pm',
                version => '0.05',
            },
            'util' => {
                file    => 'lib/util.pm',
                version => '0.05',
            },
            'noop' => {
                file    => 'lib/noop.pm',
                version => '0.05',
            },
            'const' => {
                file    => 'lib/const.pm',
                version => '0.05',
            },
            'doubly' => {
                file    => 'lib/doubly.pm',
                version => '0.05',
            },
            'object' => {
                file    => 'lib/object.pm',
                version => '0.05',
            },
            'lru' => {
                file    => 'lib/lru.pm',
                version => '0.05',
            },
        },
    },
);
