# Generated by default/object.tt
package Paws::Batch::NetworkConfiguration;
  use Moose;
  has AssignPublicIp => (is => 'ro', isa => 'Str', request_name => 'assignPublicIp', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::NetworkConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::NetworkConfiguration object:

  $service_obj->Method(Att1 => { AssignPublicIp => $value, ..., AssignPublicIp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::NetworkConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AssignPublicIp

=head1 DESCRIPTION

The network configuration for jobs running on Fargate resources. Jobs
running on EC2 resources must not specify this parameter.

=head1 ATTRIBUTES


=head2 AssignPublicIp => Str

Indicates whether the job should have a public IP address. For a job
running on Fargate resources in a private subnet to send outbound
traffic to the internet (for example, in order to pull container
images), the private subnet requires a NAT gateway be attached to route
requests to the internet. For more information, see Amazon ECS task
networking
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html).
The default value is "DISABLED".



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

