package Net::Amazon::EMR::StepSummary;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;
use Net::Amazon::EMR::HadoopStepConfig;
use Net::Amazon::EMR::StepStatus;

subtype 'Net::Amazon::EMR::Type::StepSummary::ActionOnFailure' => as 'Str' => where { m/^(?:TERMINATE_JOB_FLOW | TERMINATE_CLUSTER | CANCEL_AND_WAIT | CONTINUE)$/x };

has 'ActionOnFailure' => ( is => 'ro',
                           isa => 'Net::Amazon::EMR::Type::StepSummary::ActionOnFailure',
                       );

has 'Config' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::HadoopStepConfig',
                  coerce => 1,
              );

has 'Id' => ( is => 'ro', 
              isa => 'Str' );

has 'Name' => ( is => 'ro', 
                isa => 'Str' );

has 'NormalisedInstanceHours' => ( is => 'ro', 
                                   isa => 'Int' );

has 'Status' => ( is => 'ro',
                  isa => 'Net::Amazon::EMR::Type::StepStatus',
                  coerce => 1,
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::StepSummary

=head1 DESCRIPTION

Implements the StepSummary data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_StepSummary.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
