use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME             => 'LNATION',
    DISTNAME         => 'LNATION',
    VERSION          => '0.04',
    ABSTRACT         => 'TMTOWTDI',
    MIN_PERL_VERSION => '5.014',
    AUTHOR       => 'LNATION <email@lnation.org>',
    LICENSE      => 'perl_5',
    macro        => { TARFLAGS => "--format=ustar -c -v -f" },
    DIR          => [qw(xs/slot xs/util xs/noop xs/const xs/doubly xs/object)],
    META_MERGE   => {
        'meta-spec' => { version => 2 },
        provides => {
            'slot' => {
                file    => 'lib/slot.pm',
                version => '0.04',
            },
            'util' => {
                file    => 'lib/util.pm',
                version => '0.04',
            },
            'noop' => {
                file    => 'lib/noop.pm',
                version => '0.04',
            },
            'const' => {
                file    => 'lib/const.pm',
                version => '0.04',
            },
            'doubly' => {
                file    => 'lib/doubly.pm',
                version => '0.04',
            },
            'object' => {
                file    => 'lib/object.pm',
                version => '0.04',
            },
        },
    },
);
