#Test conversion of Unicode strings to numbers
load tcl_uninum.so uninum
#package require uninum 2.2
fconfigure  stdout -encoding utf-8
set sl {
\u0666\u0664\u0665\u0663
\u06F6\u06F4\u06F5\u06F2
\u09EB\u09E9\u09EA
\u1045\u1048\u1043\u1047
\u4E03\u4E07\u4E03
\u096A\u096B\u0969
\u1374\u1370\u137C\u1373\u1371\u137B\u1375
\u0AEB\u0AED\u0AEC\u0AE7
\u0A6D\u0A6B\u0A69\u0A6A\u0A6F
\u05D4\u05F3\u05EA\u05EA\u05DB\u05D6
\u0CED\u0CE9\u0CEB
\u17E6\u17E9\u17E5\u17E2
\uF8F7\uF8F5\uF8F9
\u0ED4\u0ED6\u0ED2\u0ED7
\u0D68\u0D6E\u0D6D\u0D69
\u1813\u1817\u1819\u1812
\u07C5\u07C8\u07C2\u07C3
\u0B69\u0B66\u0B6B\u0B6D
xlviii
xl8
\u0BEE\u0BF1\u0BE8\u0BF0\u0BE9\u0BF2\u0BE8
\u096A\u0C6B\u0969
\u0C6D\u0C6A\u0C69\u0C6B
\u0E53\u0E59\u0E56\u0E52
\u0F25\u0F28\u0F23
28375}
					
#Insert thousands separators
proc commify { num {sep ,} {groupSize 3}} {
    while {[regsub "^(\[-+]?\\d+)(\\d{$groupSize})" $num "\\1$sep\\2" num]} {}
    return $num
}

proc UninumErrorToString {n} {
    switch $n {
	128 {return "bad character"}
	129 {return "does not fit"}
	130 {return "unknown number system"}
	131 {return "invalid base"}
	132 {return "digit inconsistent with base"}
	133 {return "out of memory"}
	134 {return "number out of range of writing system"}
	135 {return "result contains character outside BMP"}
    }
}

foreach s $sl {
    set r [UNStrToWNStr $s all]
    if {$::uninum_err} {
	if {$::uninum_err == 128} {
	    puts [format "%s\t  The character %c U+%04X does not belong in a %s number."\
		      $s $::tcl_uninum_badchar $tcl_uninum_badchar [StrGuessNumberSystem $s]]
	} else {
	    puts [format "Error: %s" [UninumErrorToString $::uninum_err]]
	}
	continue
    }
    puts [format "%s\t  %-15s  %10s" $s [StrGuessNumberSystem $s] [commify $r]]
}


