package Bundle::Math::Matrix;
use strict;
use warnings;

$VERSION = '1.01';

1;

__END__

=head1 NAME

Bundle::Math::Matrix - Bundle related to math with matrices or vectors

=head1 SYNOPSIS

 perl -MCPAN -e 'install Bundle::Math::Matrix'

=head1 CONTENTS

Math::Complex            - Complex numbers are vectors of sorts

Math::GMatrix

Math::Matrix

Math::MatrixBool

Math::MatrixReal

Math::MatrixReal::Ext1

Math::MatrixSparse

Math::Orthonormalize

Math::Quaternion

Math::Vec

Math::VecStat

Math::VectorReal

=head1 DESCRIPTION

This is a bundle of modules related to math with matrices or vectors.

Please have a look at L<Bundle::Math>.

If you would like to see a specific module included in a future version of
this bundle, please send me an email or use rt.cpan.org.

=head1 AUTHOR

Steffen Mueller E<lt>bundlemath-module at steffen-mueller dot netE<gt>

=cut 
